/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Objects;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

public class QuotaByStorageTypeEntry {
    private StorageType type;
    private long quota;

    public StorageType getStorageType() {
        return this.type;
    }

    public long getQuota() {
        return this.quota;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        QuotaByStorageTypeEntry other = (QuotaByStorageTypeEntry)o;
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal(this.quota, other.quota);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.quota});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        assert (this.type != null);
        sb.append(StringUtils.toLowerCase(this.type.toString()));
        sb.append(':');
        sb.append(this.quota);
        return sb.toString();
    }

    private QuotaByStorageTypeEntry(StorageType type, long quota) {
        this.type = type;
        this.quota = quota;
    }

    public static class Builder {
        private StorageType type;
        private long quota;

        public Builder setStorageType(StorageType type) {
            this.type = type;
            return this;
        }

        public Builder setQuota(long quota) {
            this.quota = quota;
            return this;
        }

        public QuotaByStorageTypeEntry build() {
            return new QuotaByStorageTypeEntry(this.type, this.quota);
        }
    }
}

