/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Lists;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.Util;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSImagePreTransactionalStorageInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSImageStorageInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSImageTransactionalStorageInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.util.PersistentLongFile;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.DNS;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class NNStorage
extends Storage
implements Closeable,
StorageErrorReporter {
    static final String DEPRECATED_MESSAGE_DIGEST_PROPERTY = "imageMD5Digest";
    static final String LOCAL_URI_SCHEME = "file";
    protected String blockpoolID = "";
    private boolean restoreFailedStorage = false;
    private final Object restorationLock = new Object();
    private boolean disablePreUpgradableLayoutCheck = false;
    protected volatile long mostRecentCheckpointTxId = -12345L;
    private long mostRecentCheckpointTime = 0L;
    protected final List<Storage.StorageDirectory> removedStorageDirs = new CopyOnWriteArrayList<Storage.StorageDirectory>();
    private HashMap<String, String> deprecatedProperties;

    public NNStorage(Configuration conf, Collection<URI> imageDirs, Collection<URI> editsDirs) throws IOException {
        super(HdfsServerConstants.NodeType.NAME_NODE);
        this.storageDirs = new CopyOnWriteArrayList();
        this.setStorageDirectories(imageDirs, Lists.newArrayList(editsDirs), FSNamesystem.getSharedEditsDirs(conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        RandomAccessFile oldFile;
        block4: {
            boolean bl;
            if (this.disablePreUpgradableLayoutCheck) {
                return false;
            }
            File oldImageDir = new File(sd.getRoot(), "image");
            if (!oldImageDir.exists()) {
                return false;
            }
            File oldF = new File(oldImageDir, "fsimage");
            oldFile = new RandomAccessFile(oldF, "rws");
            try {
                oldFile.seek(0L);
                int oldVersion = oldFile.readInt();
                oldFile.close();
                oldFile = null;
                if (oldVersion >= -3) break block4;
                bl = false;
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, oldFile);
                throw throwable;
            }
            IOUtils.cleanup(LOG, oldFile);
            return bl;
        }
        IOUtils.cleanup(LOG, oldFile);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.unlockAll();
        this.storageDirs.clear();
    }

    void setRestoreFailedStorage(boolean val) {
        LOG.warn("set restore failed storage to " + val);
        this.restoreFailedStorage = val;
    }

    boolean getRestoreFailedStorage() {
        return this.restoreFailedStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attemptRestoreRemovedStorage() {
        if (!this.restoreFailedStorage || this.removedStorageDirs.size() == 0) {
            return;
        }
        Object object = this.restorationLock;
        synchronized (object) {
            LOG.info("NNStorage.attemptRestoreRemovedStorage: check removed(failed) storarge. removedStorages size = " + this.removedStorageDirs.size());
            for (Storage.StorageDirectory sd : this.removedStorageDirs) {
                File root = sd.getRoot();
                LOG.info("currently disabled dir " + root.getAbsolutePath() + "; type=" + sd.getStorageDirType() + ";canwrite=" + FileUtil.canWrite(root));
                if (!root.exists() || !FileUtil.canWrite(root)) continue;
                LOG.info("restoring dir " + sd.getRoot().getAbsolutePath());
                this.addStorageDir(sd);
                this.removedStorageDirs.remove(sd);
            }
        }
    }

    List<Storage.StorageDirectory> getRemovedStorageDirs() {
        return this.removedStorageDirs;
    }

    @VisibleForTesting
    synchronized void setStorageDirectories(Collection<URI> fsNameDirs, Collection<URI> fsEditsDirs) throws IOException {
        this.setStorageDirectories(fsNameDirs, fsEditsDirs, new ArrayList<URI>());
    }

    @VisibleForTesting
    synchronized void setStorageDirectories(Collection<URI> fsNameDirs, Collection<URI> fsEditsDirs, Collection<URI> sharedEditsDirs) throws IOException {
        this.storageDirs.clear();
        this.removedStorageDirs.clear();
        for (URI dirName : fsNameDirs) {
            NameNodeDirType dirType;
            NNStorage.checkSchemeConsistency(dirName);
            boolean isAlsoEdits = false;
            for (URI editsDirName : fsEditsDirs) {
                if (editsDirName.compareTo(dirName) != 0) continue;
                isAlsoEdits = true;
                fsEditsDirs.remove(editsDirName);
                break;
            }
            NameNodeDirType nameNodeDirType = dirType = isAlsoEdits ? NameNodeDirType.IMAGE_AND_EDITS : NameNodeDirType.IMAGE;
            if (dirName.getScheme().compareTo(LOCAL_URI_SCHEME) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), dirType, sharedEditsDirs.contains(dirName)));
        }
        for (URI dirName : fsEditsDirs) {
            NNStorage.checkSchemeConsistency(dirName);
            if (dirName.getScheme().compareTo(LOCAL_URI_SCHEME) != 0) continue;
            this.addStorageDir(new Storage.StorageDirectory(new File(dirName.getPath()), NameNodeDirType.EDITS, sharedEditsDirs.contains(dirName)));
        }
    }

    Storage.StorageDirectory getStorageDirectory(URI uri) {
        try {
            uri = Util.fileAsURI(new File(uri));
            Iterator<Storage.StorageDirectory> it = this.dirIterator();
            while (it.hasNext()) {
                Storage.StorageDirectory sd = it.next();
                if (!Util.fileAsURI(sd.getRoot()).equals(uri)) continue;
                return sd;
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error converting file to URI", ioe);
        }
        return null;
    }

    private static void checkSchemeConsistency(URI u) throws IOException {
        String scheme = u.getScheme();
        if (scheme == null) {
            throw new IOException("Undefined scheme for " + u);
        }
    }

    Collection<URI> getImageDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.IMAGE);
    }

    Collection<URI> getEditsDirectories() throws IOException {
        return this.getDirectories(NameNodeDirType.EDITS);
    }

    int getNumStorageDirs(NameNodeDirType dirType) {
        if (dirType == null) {
            return this.getNumStorageDirs();
        }
        Iterator<Storage.StorageDirectory> it = this.dirIterator(dirType);
        int numDirs = 0;
        while (it.hasNext()) {
            ++numDirs;
            it.next();
        }
        return numDirs;
    }

    Collection<URI> getDirectories(NameNodeDirType dirType) throws IOException {
        Iterator<Storage.StorageDirectory> it;
        ArrayList<URI> list = new ArrayList<URI>();
        Iterator<Storage.StorageDirectory> iterator = it = dirType == null ? this.dirIterator() : this.dirIterator(dirType);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                list.add(Util.fileAsURI(sd.getRoot()));
            }
            catch (IOException e) {
                throw new IOException("Exception while processing StorageDirectory " + sd.getRoot(), e);
            }
        }
        return list;
    }

    static long readTransactionIdFile(Storage.StorageDirectory sd) throws IOException {
        File txidFile = NNStorage.getStorageFile(sd, NameNodeFile.SEEN_TXID);
        return PersistentLongFile.readFile(txidFile, 0L);
    }

    void writeTransactionIdFile(Storage.StorageDirectory sd, long txid) throws IOException {
        Preconditions.checkArgument(txid >= 0L, "bad txid: " + txid);
        File txIdFile = NNStorage.getStorageFile(sd, NameNodeFile.SEEN_TXID);
        PersistentLongFile.writeFile(txIdFile, txid);
    }

    void setMostRecentCheckpointInfo(long txid, long time) {
        this.mostRecentCheckpointTxId = txid;
        this.mostRecentCheckpointTime = time;
    }

    public long getMostRecentCheckpointTxId() {
        return this.mostRecentCheckpointTxId;
    }

    long getMostRecentCheckpointTime() {
        return this.mostRecentCheckpointTime;
    }

    public void writeTransactionIdFileToStorage(long txid) {
        this.writeTransactionIdFileToStorage(txid, null);
    }

    public void writeTransactionIdFileToStorage(long txid, NameNodeDirType type) {
        Iterator<Storage.StorageDirectory> it = this.dirIterator(type);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            try {
                this.writeTransactionIdFile(sd, txid);
            }
            catch (IOException e) {
                LOG.warn("writeTransactionIdToStorage failed on " + sd, e);
                this.reportErrorsOnDirectory(sd);
            }
        }
    }

    public File[] getFsImageNameCheckpoint(long txid) {
        ArrayList<File> list = new ArrayList<File>();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            list.add(NNStorage.getStorageFile(it.next(), NameNodeFile.IMAGE_NEW, txid));
        }
        return list.toArray(new File[list.size()]);
    }

    public File getFsImageName(long txid, NameNodeFile nnf) {
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            File fsImage = NNStorage.getStorageFile(sd, nnf, txid);
            if (!FileUtil.canRead(sd.getRoot()) || !fsImage.exists()) continue;
            return fsImage;
        }
        return null;
    }

    public File getFsImage(long txid, EnumSet<NameNodeFile> nnfs) {
        Iterator<Storage.StorageDirectory> it = this.dirIterator(NameNodeDirType.IMAGE);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            for (NameNodeFile nnf : nnfs) {
                File fsImage = NNStorage.getStorageFile(sd, nnf, txid);
                if (!FileUtil.canRead(sd.getRoot()) || !fsImage.exists()) continue;
                return fsImage;
            }
        }
        return null;
    }

    public File getFsImageName(long txid) {
        return this.getFsImageName(txid, NameNodeFile.IMAGE);
    }

    public File getHighestFsImageName() {
        return this.getFsImageName(this.getMostRecentCheckpointTxId());
    }

    private void format(Storage.StorageDirectory sd) throws IOException {
        sd.clearDirectory();
        this.writeProperties(sd);
        this.writeTransactionIdFile(sd, 0L);
        LOG.info("Storage directory " + sd.getRoot() + " has been successfully formatted.");
    }

    public void format(NamespaceInfo nsInfo) throws IOException {
        Preconditions.checkArgument(nsInfo.getLayoutVersion() == 0 || nsInfo.getLayoutVersion() == HdfsConstants.NAMENODE_LAYOUT_VERSION, "Bad layout version: %s", nsInfo.getLayoutVersion());
        this.setStorageInfo(nsInfo);
        this.blockpoolID = nsInfo.getBlockPoolID();
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            this.format(sd);
        }
    }

    public static NamespaceInfo newNamespaceInfo() throws UnknownHostException {
        return new NamespaceInfo(NNStorage.newNamespaceID(), NNStorage.newClusterID(), NNStorage.newBlockPoolID(), 0L);
    }

    public void format() throws IOException {
        this.layoutVersion = HdfsConstants.NAMENODE_LAYOUT_VERSION;
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            this.format(sd);
        }
    }

    private static int newNamespaceID() {
        int newID = 0;
        while (newID == 0) {
            newID = DFSUtil.getRandom().nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setFieldsFromProperties(props, sd);
        if (this.layoutVersion == 0) {
            throw new IOException("NameNode directory " + sd.getRoot() + " is not formatted.");
        }
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.getLayoutVersion())) {
            String sbpid = props.getProperty("blockpoolID");
            this.setBlockPoolID(sd.getRoot(), sbpid);
        }
        this.setDeprecatedPropertiesForUpgrade(props);
    }

    void readProperties(Storage.StorageDirectory sd, HdfsServerConstants.StartupOption startupOption) throws IOException {
        Properties props = NNStorage.readPropertiesFile(sd.getVersionFile());
        if (HdfsServerConstants.RollingUpgradeStartupOption.ROLLBACK.matches(startupOption)) {
            int lv = Integer.parseInt(NNStorage.getProperty(props, sd, "layoutVersion"));
            if (lv > this.getServiceLayoutVersion()) {
                throw new IncorrectVersionException(this.getServiceLayoutVersion(), lv, "storage directory " + sd.getRoot().getAbsolutePath());
            }
            props.setProperty("layoutVersion", Integer.toString(HdfsConstants.NAMENODE_LAYOUT_VERSION));
        }
        this.setFieldsFromProperties(props, sd);
    }

    private void setDeprecatedPropertiesForUpgrade(Properties props) {
        this.deprecatedProperties = new HashMap();
        String md5 = props.getProperty(DEPRECATED_MESSAGE_DIGEST_PROPERTY);
        if (md5 != null) {
            this.deprecatedProperties.put(DEPRECATED_MESSAGE_DIGEST_PROPERTY, md5);
        }
    }

    String getDeprecatedProperty(String prop) {
        assert (this.getLayoutVersion() > HdfsConstants.NAMENODE_LAYOUT_VERSION) : "getDeprecatedProperty should only be done when loading storage from past versions during upgrade.";
        return this.deprecatedProperties.get(prop);
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        super.setPropertiesFromFields(props, sd);
        if (NameNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.getLayoutVersion())) {
            props.setProperty("blockpoolID", this.blockpoolID);
        }
    }

    static File getStorageFile(Storage.StorageDirectory sd, NameNodeFile type, long imageTxId) {
        return new File(sd.getCurrentDir(), String.format("%s_%019d", type.getName(), imageTxId));
    }

    static File getStorageFile(Storage.StorageDirectory sd, NameNodeFile type) {
        return new File(sd.getCurrentDir(), type.getName());
    }

    @VisibleForTesting
    public static String getCheckpointImageFileName(long txid) {
        return NNStorage.getNameNodeFileName(NameNodeFile.IMAGE_NEW, txid);
    }

    @VisibleForTesting
    public static String getImageFileName(long txid) {
        return NNStorage.getNameNodeFileName(NameNodeFile.IMAGE, txid);
    }

    @VisibleForTesting
    public static String getRollbackImageFileName(long txid) {
        return NNStorage.getNameNodeFileName(NameNodeFile.IMAGE_ROLLBACK, txid);
    }

    public static String getLegacyOIVImageFileName(long txid) {
        return NNStorage.getNameNodeFileName(NameNodeFile.IMAGE_LEGACY_OIV, txid);
    }

    private static String getNameNodeFileName(NameNodeFile nnf, long txid) {
        return String.format("%s_%019d", nnf.getName(), txid);
    }

    @VisibleForTesting
    public static String getInProgressEditsFileName(long startTxId) {
        return NNStorage.getNameNodeFileName(NameNodeFile.EDITS_INPROGRESS, startTxId);
    }

    static File getInProgressEditsFile(Storage.StorageDirectory sd, long startTxId) {
        return new File(sd.getCurrentDir(), NNStorage.getInProgressEditsFileName(startTxId));
    }

    static File getFinalizedEditsFile(Storage.StorageDirectory sd, long startTxId, long endTxId) {
        return new File(sd.getCurrentDir(), NNStorage.getFinalizedEditsFileName(startTxId, endTxId));
    }

    static File getTemporaryEditsFile(Storage.StorageDirectory sd, long startTxId, long endTxId, long timestamp) {
        return new File(sd.getCurrentDir(), NNStorage.getTemporaryEditsFileName(startTxId, endTxId, timestamp));
    }

    static File getImageFile(Storage.StorageDirectory sd, NameNodeFile nnf, long txid) {
        return new File(sd.getCurrentDir(), NNStorage.getNameNodeFileName(nnf, txid));
    }

    @VisibleForTesting
    public static String getFinalizedEditsFileName(long startTxId, long endTxId) {
        return String.format("%s_%019d-%019d", NameNodeFile.EDITS.getName(), startTxId, endTxId);
    }

    public static String getTemporaryEditsFileName(long startTxId, long endTxId, long timestamp) {
        return String.format("%s_%019d-%019d_%019d", NameNodeFile.EDITS_TMP.getName(), startTxId, endTxId, timestamp);
    }

    File findFinalizedEditsFile(long startTxId, long endTxId) throws IOException {
        File ret = this.findFile(NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName(startTxId, endTxId));
        if (ret == null) {
            throw new IOException("No edits file for txid " + startTxId + "-" + endTxId + " exists!");
        }
        return ret;
    }

    File findImageFile(NameNodeFile nnf, long txid) {
        return this.findFile(NameNodeDirType.IMAGE, NNStorage.getNameNodeFileName(nnf, txid));
    }

    private File findFile(NameNodeDirType dirType, String name) {
        for (Storage.StorageDirectory sd : this.dirIterable(dirType)) {
            File candidate = new File(sd.getCurrentDir(), name);
            if (!FileUtil.canRead(sd.getCurrentDir()) || !candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    void setDisablePreUpgradableLayoutCheck(boolean val) {
        this.disablePreUpgradableLayoutCheck = val;
    }

    void reportErrorsOnDirectories(List<Storage.StorageDirectory> sds) {
        for (Storage.StorageDirectory sd : sds) {
            this.reportErrorsOnDirectory(sd);
        }
    }

    private void reportErrorsOnDirectory(Storage.StorageDirectory sd) {
        LOG.error("Error reported on storage directory " + sd);
        String lsd = this.listStorageDirectories();
        LOG.debug("current list of storage dirs:" + lsd);
        LOG.warn("About to remove corresponding storage: " + sd.getRoot().getAbsolutePath());
        try {
            sd.unlock();
        }
        catch (Exception e) {
            LOG.warn("Unable to unlock bad storage directory: " + sd.getRoot().getPath(), e);
        }
        if (this.storageDirs.remove(sd)) {
            this.removedStorageDirs.add(sd);
        }
        lsd = this.listStorageDirectories();
        LOG.debug("at the end current list of storage dirs:" + lsd);
    }

    void processStartupOptionsForUpgrade(HdfsServerConstants.StartupOption startOpt, int layoutVersion) throws IOException {
        if (startOpt == HdfsServerConstants.StartupOption.UPGRADE || startOpt == HdfsServerConstants.StartupOption.UPGRADEONLY) {
            if (!NameNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, layoutVersion)) {
                if (startOpt.getClusterId() == null) {
                    startOpt.setClusterId(NNStorage.newClusterID());
                }
                this.setClusterID(startOpt.getClusterId());
                this.setBlockPoolID(NNStorage.newBlockPoolID());
            } else if (startOpt.getClusterId() != null && !startOpt.getClusterId().equals(this.getClusterID())) {
                LOG.warn("Clusterid mismatch - current clusterid: " + this.getClusterID() + ", Ignoring given clusterid: " + startOpt.getClusterId());
            }
            LOG.info("Using clusterid: " + this.getClusterID());
        }
    }

    @Override
    public void reportErrorOnFile(File f) {
        String absPath = f.getAbsolutePath();
        for (Storage.StorageDirectory sd : this.storageDirs) {
            String dirPath = sd.getRoot().getAbsolutePath();
            if (!dirPath.endsWith(File.separator)) {
                dirPath = dirPath + File.separator;
            }
            if (!absPath.startsWith(dirPath)) continue;
            this.reportErrorsOnDirectory(sd);
            return;
        }
    }

    public static String newClusterID() {
        return "CID-" + UUID.randomUUID().toString();
    }

    void setClusterID(String cid) {
        this.clusterID = cid;
    }

    public String determineClusterId() {
        String cid = null;
        Iterator<Storage.StorageDirectory> sdit = this.dirIterator(NameNodeDirType.IMAGE);
        while (sdit.hasNext()) {
            Storage.StorageDirectory sd = sdit.next();
            try {
                Properties props = NNStorage.readPropertiesFile(sd.getVersionFile());
                cid = props.getProperty("clusterID");
                LOG.info("current cluster id for sd=" + sd.getCurrentDir() + ";lv=" + this.layoutVersion + ";cid=" + cid);
                if (cid == null || cid.equals("")) continue;
                return cid;
            }
            catch (Exception e) {
                LOG.warn("this sd not available: " + e.getLocalizedMessage());
            }
        }
        LOG.warn("couldn't find any VERSION file containing valid ClusterId");
        return null;
    }

    static String newBlockPoolID() throws UnknownHostException {
        String ip = "unknownIP";
        try {
            ip = DNS.getDefaultIP("default");
        }
        catch (UnknownHostException e) {
            LOG.warn("Could not find ip address of \"default\" inteface.");
            throw e;
        }
        int rand = DFSUtil.getSecureRandom().nextInt(Integer.MAX_VALUE);
        String bpid = "BP-" + rand + "-" + ip + "-" + Time.now();
        return bpid;
    }

    public void setBlockPoolID(String bpid) {
        this.blockpoolID = bpid;
    }

    private void setBlockPoolID(File storage, String bpid) throws InconsistentFSStateException {
        if (bpid == null || bpid.equals("")) {
            throw new InconsistentFSStateException(storage, "file VERSION has no block pool Id.");
        }
        if (!this.blockpoolID.equals("") && !this.blockpoolID.equals(bpid)) {
            throw new InconsistentFSStateException(storage, "Unexepcted blockpoolID " + bpid + " . Expected " + this.blockpoolID);
        }
        this.setBlockPoolID(bpid);
    }

    public String getBlockPoolID() {
        return this.blockpoolID;
    }

    void inspectStorageDirs(FSImageStorageInspector inspector) throws IOException {
        Iterator<Storage.StorageDirectory> it = this.dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            inspector.inspectDirectory(sd);
        }
    }

    FSImageStorageInspector readAndInspectDirs(EnumSet<NameNodeFile> fileTypes, HdfsServerConstants.StartupOption startupOption) throws IOException {
        Integer layoutVersion = null;
        boolean multipleLV = false;
        StringBuilder layoutVersions = new StringBuilder();
        Iterator<Storage.StorageDirectory> it = this.dirIterator(false);
        while (it.hasNext()) {
            Storage.StorageDirectory sd = it.next();
            if (!sd.getVersionFile().exists()) {
                FSImage.LOG.warn("Storage directory " + sd + " contains no VERSION file. Skipping...");
                continue;
            }
            this.readProperties(sd, startupOption);
            int lv = this.getLayoutVersion();
            if (layoutVersion == null) {
                layoutVersion = lv;
            } else if (!layoutVersion.equals(lv)) {
                multipleLV = true;
            }
            layoutVersions.append("(").append(sd.getRoot()).append(", ").append(lv).append(") ");
        }
        if (layoutVersion == null) {
            throw new IOException("No storage directories contained VERSION information");
        }
        if (multipleLV) {
            throw new IOException("Storage directories contain multiple layout versions: " + layoutVersions);
        }
        FSImageStorageInspector inspector = NameNodeLayoutVersion.supports(LayoutVersion.Feature.TXID_BASED_LAYOUT, this.getLayoutVersion()) ? new FSImageTransactionalStorageInspector(fileTypes) : new FSImagePreTransactionalStorageInspector();
        this.inspectStorageDirs(inspector);
        return inspector;
    }

    public NamespaceInfo getNamespaceInfo() {
        return new NamespaceInfo(this.getNamespaceID(), this.getClusterID(), this.getBlockPoolID(), this.getCTime());
    }

    @VisibleForTesting
    public static enum NameNodeDirType implements Storage.StorageDirType
    {
        UNDEFINED,
        IMAGE,
        EDITS,
        IMAGE_AND_EDITS;


        @Override
        public Storage.StorageDirType getStorageDirType() {
            return this;
        }

        @Override
        public boolean isOfType(Storage.StorageDirType type) {
            if (this == IMAGE_AND_EDITS && (type == IMAGE || type == EDITS)) {
                return true;
            }
            return this == type;
        }
    }

    public static enum NameNodeFile {
        IMAGE("fsimage"),
        TIME("fstime"),
        SEEN_TXID("seen_txid"),
        EDITS("edits"),
        IMAGE_NEW("fsimage.ckpt"),
        IMAGE_ROLLBACK("fsimage_rollback"),
        EDITS_NEW("edits.new"),
        EDITS_INPROGRESS("edits_inprogress"),
        EDITS_TMP("edits_tmp"),
        IMAGE_LEGACY_OIV("fsimage_legacy_oiv");

        private String fileName = null;

        private NameNodeFile(String name) {
            this.fileName = name;
        }

        @VisibleForTesting
        public String getName() {
            return this.fileName;
        }
    }
}

