/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum FSEditLogOpCodes {
    OP_ADD(0),
    OP_RENAME_OLD(1),
    OP_DELETE(2),
    OP_MKDIR(3),
    OP_SET_REPLICATION(4),
    OP_DATANODE_ADD(5),
    OP_DATANODE_REMOVE(6),
    OP_SET_PERMISSIONS(7),
    OP_SET_OWNER(8),
    OP_CLOSE(9),
    OP_SET_GENSTAMP_V1(10),
    OP_SET_NS_QUOTA(11),
    OP_CLEAR_NS_QUOTA(12),
    OP_TIMES(13),
    OP_SET_QUOTA(14),
    OP_RENAME(15),
    OP_CONCAT_DELETE(16),
    OP_SYMLINK(17),
    OP_GET_DELEGATION_TOKEN(18),
    OP_RENEW_DELEGATION_TOKEN(19),
    OP_CANCEL_DELEGATION_TOKEN(20),
    OP_UPDATE_MASTER_KEY(21),
    OP_REASSIGN_LEASE(22),
    OP_END_LOG_SEGMENT(23),
    OP_START_LOG_SEGMENT(24),
    OP_UPDATE_BLOCKS(25),
    OP_CREATE_SNAPSHOT(26),
    OP_DELETE_SNAPSHOT(27),
    OP_RENAME_SNAPSHOT(28),
    OP_ALLOW_SNAPSHOT(29),
    OP_DISALLOW_SNAPSHOT(30),
    OP_SET_GENSTAMP_V2(31),
    OP_ALLOCATE_BLOCK_ID(32),
    OP_ADD_BLOCK(33),
    OP_ADD_CACHE_DIRECTIVE(34),
    OP_REMOVE_CACHE_DIRECTIVE(35),
    OP_ADD_CACHE_POOL(36),
    OP_MODIFY_CACHE_POOL(37),
    OP_REMOVE_CACHE_POOL(38),
    OP_MODIFY_CACHE_DIRECTIVE(39),
    OP_SET_ACL(40),
    OP_ROLLING_UPGRADE_START(41),
    OP_ROLLING_UPGRADE_FINALIZE(42),
    OP_SET_XATTR(43),
    OP_REMOVE_XATTR(44),
    OP_SET_STORAGE_POLICY(45),
    OP_TRUNCATE(46),
    OP_APPEND(47),
    OP_SET_QUOTA_BY_STORAGETYPE(48),
    OP_INVALID(-1);

    private final byte opCode;
    private static final FSEditLogOpCodes[] VALUES;

    private FSEditLogOpCodes(byte opCode) {
        this.opCode = opCode;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public static FSEditLogOpCodes fromByte(byte opCode) {
        if (opCode >= 0 && opCode < VALUES.length) {
            return VALUES[opCode];
        }
        return opCode == -1 ? OP_INVALID : null;
    }

    static {
        byte max = 0;
        for (FSEditLogOpCodes code : FSEditLogOpCodes.values()) {
            if (code.getOpCode() <= max) continue;
            max = code.getOpCode();
        }
        VALUES = new FSEditLogOpCodes[max + 1];
        for (FSEditLogOpCodes code : FSEditLogOpCodes.values()) {
            if (code.getOpCode() < 0) continue;
            FSEditLogOpCodes.VALUES[code.getOpCode()] = code;
        }
    }
}

