/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.AclStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.INodesInPath;

class FSDirAclOp {
    FSDirAclOp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus modifyAclEntries(FSDirectory fsd, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        fsd.writeLock();
        try {
            iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus removeAclEntries(FSDirectory fsd, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        fsd.writeLock();
        try {
            iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus removeDefaultAcl(FSDirectory fsd, String srcArg) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        fsd.writeLock();
        try {
            iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
            fsd.checkOwner(pc, iip);
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getLatestSnapshotId();
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
            AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus removeAcl(FSDirectory fsd, String srcArg) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        fsd.writeLock();
        try {
            iip = fsd.getINodesInPath4Write(src);
            fsd.checkOwner(pc, iip);
            FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logSetAcl(src, AclFeature.EMPTY_ENTRY_LIST);
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HdfsFileStatus setAcl(FSDirectory fsd, String srcArg, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip;
        String src = srcArg;
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        src = fsd.resolvePath(pc, src, pathComponents);
        fsd.writeLock();
        try {
            iip = fsd.getINodesInPath4Write(src);
            fsd.checkOwner(pc, iip);
            List<AclEntry> newAcl = FSDirAclOp.unprotectedSetAcl(fsd, src, aclSpec, false);
            fsd.getEditLog().logSetAcl(src, newAcl);
        }
        finally {
            fsd.writeUnlock();
        }
        return fsd.getAuditFileInfo(iip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AclStatus getAclStatus(FSDirectory fsd, String src) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        FSPermissionChecker pc = fsd.getPermissionChecker();
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(src);
        src = fsd.resolvePath(pc, src, pathComponents);
        String srcs = FSDirectory.normalizePath(src);
        fsd.readLock();
        try {
            if (srcs.endsWith("/.snapshot") && fsd.getINode4DotSnapshot(srcs) != null) {
                AclStatus aclStatus = new AclStatus.Builder().owner("").group("").build();
                return aclStatus;
            }
            INodesInPath iip = fsd.getINodesInPath(srcs, true);
            if (fsd.isPermissionEnabled()) {
                fsd.checkTraverse(pc, iip);
            }
            INode inode = FSDirectory.resolveLastINode(iip);
            int snapshotId = iip.getPathSnapshotId();
            List<AclEntry> acl = AclStorage.readINodeAcl(fsd.getAttributes(src, inode.getLocalNameBytes(), inode, snapshotId));
            FsPermission fsPermission = inode.getFsPermission(snapshotId);
            AclStatus aclStatus = new AclStatus.Builder().owner(inode.getUserName()).group(inode.getGroupName()).stickyBit(fsPermission.getStickyBit()).setPermission(fsPermission).addEntries(acl).build();
            return aclStatus;
        }
        finally {
            fsd.readUnlock();
        }
    }

    static List<AclEntry> unprotectedSetAcl(FSDirectory fsd, String src, List<AclEntry> aclSpec, boolean fromEdits) throws IOException {
        assert (fsd.hasWriteLock());
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        if (aclSpec.isEmpty()) {
            FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        INode inode = FSDirectory.resolveLastINode(iip);
        int snapshotId = iip.getLatestSnapshotId();
        List<AclEntry> newAcl = aclSpec;
        if (!fromEdits) {
            List<AclEntry> existingAcl = AclStorage.readINodeLogicalAcl(inode);
            newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        }
        AclStorage.updateINodeAcl(inode, newAcl, snapshotId);
        return newAcl;
    }

    private static void checkAclsConfigFlag(FSDirectory fsd) throws AclException {
        if (!fsd.isAclsEnabled()) {
            throw new AclException(String.format("The ACL operation has been rejected.  Support for ACLs has been disabled by setting %s to false.", "dfs.namenode.acls.enabled"));
        }
    }

    private static void unprotectedRemoveAcl(FSDirectory fsd, INodesInPath iip) throws IOException {
        assert (fsd.hasWriteLock());
        INode inode = FSDirectory.resolveLastINode(iip);
        int snapshotId = iip.getLatestSnapshotId();
        AclFeature f = inode.getAclFeature();
        if (f == null) {
            return;
        }
        FsPermission perm = inode.getFsPermission();
        ImmutableList<AclEntry> featureEntries = AclStorage.getEntriesFromAclFeature(f);
        if (((AclEntry)featureEntries.get(0)).getScope() == AclEntryScope.ACCESS) {
            AclEntry groupEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build();
            int groupEntryIndex = Collections.binarySearch(featureEntries, groupEntryKey, AclTransformation.ACL_ENTRY_COMPARATOR);
            assert (groupEntryIndex >= 0);
            FsAction groupPerm = ((AclEntry)featureEntries.get(groupEntryIndex)).getPermission();
            FsPermission newPerm = new FsPermission(perm.getUserAction(), groupPerm, perm.getOtherAction(), perm.getStickyBit());
            inode.setPermission(newPerm, snapshotId);
        }
        inode.removeAclFeature(snapshotId);
    }
}

