/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.base.Joiner;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;

@InterfaceAudience.Private
public class StorageInfo {
    public int layoutVersion;
    public int namespaceID;
    public String clusterID;
    public long cTime;
    protected final HdfsServerConstants.NodeType storageType;
    protected static final String STORAGE_FILE_VERSION = "VERSION";

    public StorageInfo(HdfsServerConstants.NodeType type) {
        this(0, 0, "", 0L, type);
    }

    public StorageInfo(int layoutV, int nsID, String cid, long cT, HdfsServerConstants.NodeType type) {
        this.layoutVersion = layoutV;
        this.clusterID = cid;
        this.namespaceID = nsID;
        this.cTime = cT;
        this.storageType = type;
    }

    public StorageInfo(StorageInfo from) {
        this(from.layoutVersion, from.namespaceID, from.clusterID, from.cTime, from.storageType);
    }

    public int getLayoutVersion() {
        return this.layoutVersion;
    }

    public int getNamespaceID() {
        return this.namespaceID;
    }

    public String getClusterID() {
        return this.clusterID;
    }

    public long getCTime() {
        return this.cTime;
    }

    public void setStorageInfo(StorageInfo from) {
        this.layoutVersion = from.layoutVersion;
        this.clusterID = from.clusterID;
        this.namespaceID = from.namespaceID;
        this.cTime = from.cTime;
    }

    public boolean versionSupportsFederation(Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> map) {
        return LayoutVersion.supports(map, LayoutVersion.Feature.FEDERATION, this.layoutVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lv=").append(this.layoutVersion).append(";cid=").append(this.clusterID).append(";nsid=").append(this.namespaceID).append(";c=").append(this.cTime);
        return sb.toString();
    }

    public String toColonSeparatedString() {
        return Joiner.on(":").join(this.layoutVersion, this.namespaceID, this.cTime, this.clusterID);
    }

    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setLayoutVersion(props, sd);
        this.setNamespaceID(props, sd);
        this.setcTime(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
        this.checkStorageType(props, sd);
    }

    protected void checkStorageType(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        if (this.storageType == null) {
            return;
        }
        HdfsServerConstants.NodeType type = HdfsServerConstants.NodeType.valueOf(StorageInfo.getProperty(props, sd, "storageType"));
        if (!this.storageType.equals((Object)type)) {
            throw new InconsistentFSStateException(sd.root, "Incompatible node types: storageType=" + (Object)((Object)this.storageType) + " but StorageDirectory type=" + (Object)((Object)type));
        }
    }

    protected void setcTime(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        this.cTime = Long.parseLong(StorageInfo.getProperty(props, sd, "cTime"));
    }

    protected void setClusterId(Properties props, int layoutVersion, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        if (LayoutVersion.supports(this.getServiceLayoutFeatureMap(), LayoutVersion.Feature.FEDERATION, layoutVersion)) {
            String cid = StorageInfo.getProperty(props, sd, "clusterID");
            if (!(this.clusterID.equals("") || cid.equals("") || this.clusterID.equals(cid))) {
                throw new InconsistentFSStateException(sd.getRoot(), "cluster Id is incompatible with others.");
            }
            this.clusterID = cid;
        }
    }

    protected void setLayoutVersion(Properties props, Storage.StorageDirectory sd) throws IncorrectVersionException, InconsistentFSStateException {
        int lv = Integer.parseInt(StorageInfo.getProperty(props, sd, "layoutVersion"));
        if (lv < this.getServiceLayoutVersion()) {
            throw new IncorrectVersionException(this.getServiceLayoutVersion(), lv, "storage directory " + sd.root.getAbsolutePath());
        }
        this.layoutVersion = lv;
    }

    protected void setNamespaceID(Properties props, Storage.StorageDirectory sd) throws InconsistentFSStateException {
        int nsId = Integer.parseInt(StorageInfo.getProperty(props, sd, "namespaceID"));
        if (this.namespaceID != 0 && nsId != 0 && this.namespaceID != nsId) {
            throw new InconsistentFSStateException(sd.root, "namespaceID is incompatible with others.");
        }
        this.namespaceID = nsId;
    }

    public void setServiceLayoutVersion(int lv) {
        this.layoutVersion = lv;
    }

    public int getServiceLayoutVersion() {
        return this.storageType == HdfsServerConstants.NodeType.DATA_NODE ? HdfsConstants.DATANODE_LAYOUT_VERSION : HdfsConstants.NAMENODE_LAYOUT_VERSION;
    }

    public Map<Integer, SortedSet<LayoutVersion.LayoutFeature>> getServiceLayoutFeatureMap() {
        return this.storageType == HdfsServerConstants.NodeType.DATA_NODE ? DataNodeLayoutVersion.FEATURES : NameNodeLayoutVersion.FEATURES;
    }

    protected static String getProperty(Properties props, Storage.StorageDirectory sd, String name) throws InconsistentFSStateException {
        String property = props.getProperty(name);
        if (property == null) {
            throw new InconsistentFSStateException(sd.root, "file VERSION has " + name + " missing.");
        }
        return property;
    }

    public static int getNsIdFromColonSeparatedString(String in) {
        return Integer.parseInt(in.split(":")[1]);
    }

    public static String getClusterIdFromColonSeparatedString(String in) {
        return in.split(":")[3];
    }

    public void readProperties(Storage.StorageDirectory sd) throws IOException {
        Properties props = StorageInfo.readPropertiesFile(sd.getVersionFile());
        this.setFieldsFromProperties(props, sd);
    }

    public void readPreviousVersionProperties(Storage.StorageDirectory sd) throws IOException {
        Properties props = StorageInfo.readPropertiesFile(sd.getPreviousVersionFile());
        this.setFieldsFromProperties(props, sd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesFile(File from) throws IOException {
        RandomAccessFile file = new RandomAccessFile(from, "rws");
        FileInputStream in = null;
        Properties props = new Properties();
        try {
            in = new FileInputStream(file.getFD());
            file.seek(0L);
            props.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
            file.close();
        }
        return props;
    }
}

