/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.slf4j.Logger;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.Block;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Daemon;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Time;

class PendingReplicationBlocks {
    private static final Logger LOG = BlockManager.LOG;
    private final Map<Block, PendingBlockInfo> pendingReplications;
    private final ArrayList<Block> timedOutItems;
    Daemon timerThread = null;
    private volatile boolean fsRunning = true;
    private long timeout = 300000L;
    private static final long DEFAULT_RECHECK_INTERVAL = 300000L;

    PendingReplicationBlocks(long timeoutPeriod) {
        if (timeoutPeriod > 0L) {
            this.timeout = timeoutPeriod;
        }
        this.pendingReplications = new HashMap<Block, PendingBlockInfo>();
        this.timedOutItems = new ArrayList();
    }

    void start() {
        this.timerThread = new Daemon(new PendingReplicationMonitor());
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increment(Block block, DatanodeDescriptor[] targets) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found == null) {
                this.pendingReplications.put(block, new PendingBlockInfo(targets));
            } else {
                found.incrementReplicas(targets);
                found.setTimeStamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrement(Block block, DatanodeDescriptor dn) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Removing pending replication for " + block);
                }
                found.decrementReplicas(dn);
                if (found.getNumReplicas() <= 0) {
                    this.pendingReplications.remove(block);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            this.pendingReplications.remove(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            this.pendingReplications.clear();
            this.timedOutItems.clear();
        }
    }

    int size() {
        return this.pendingReplications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumReplicas(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                return found.getNumReplicas();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getTimedOutBlocks() {
        ArrayList<Block> arrayList = this.timedOutItems;
        synchronized (arrayList) {
            if (this.timedOutItems.size() <= 0) {
                return null;
            }
            Block[] blockList = this.timedOutItems.toArray(new Block[this.timedOutItems.size()]);
            this.timedOutItems.clear();
            return blockList;
        }
    }

    void stop() {
        this.fsRunning = false;
        if (this.timerThread == null) {
            return;
        }
        this.timerThread.interrupt();
        try {
            this.timerThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(PrintWriter out) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            out.println("Metasave: Blocks being replicated: " + this.pendingReplications.size());
            for (Map.Entry<Block, PendingBlockInfo> entry : this.pendingReplications.entrySet()) {
                PendingBlockInfo pendingBlock = entry.getValue();
                Block block = entry.getKey();
                out.println(block + " StartTime: " + new java.sql.Time(pendingBlock.timeStamp) + " NumReplicaInProgress: " + pendingBlock.getNumReplicas());
            }
        }
    }

    class PendingReplicationMonitor
    implements Runnable {
        PendingReplicationMonitor() {
        }

        @Override
        public void run() {
            while (PendingReplicationBlocks.this.fsRunning) {
                long period = Math.min(300000L, PendingReplicationBlocks.this.timeout);
                try {
                    this.pendingReplicationCheck();
                    Thread.sleep(period);
                }
                catch (InterruptedException ie) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("PendingReplicationMonitor thread is interrupted.", ie);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pendingReplicationCheck() {
            Map map = PendingReplicationBlocks.this.pendingReplications;
            synchronized (map) {
                Iterator iter = PendingReplicationBlocks.this.pendingReplications.entrySet().iterator();
                long now = Time.monotonicNow();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PendingReplicationMonitor checking Q");
                }
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    PendingBlockInfo pendingBlock = (PendingBlockInfo)entry.getValue();
                    if (now <= pendingBlock.getTimeStamp() + PendingReplicationBlocks.this.timeout) continue;
                    Block block = (Block)entry.getKey();
                    ArrayList arrayList = PendingReplicationBlocks.this.timedOutItems;
                    synchronized (arrayList) {
                        PendingReplicationBlocks.this.timedOutItems.add(block);
                    }
                    LOG.warn("PendingReplicationMonitor timed out " + block);
                    iter.remove();
                }
            }
        }
    }

    static class PendingBlockInfo {
        private long timeStamp = Time.monotonicNow();
        private final List<DatanodeDescriptor> targets;

        PendingBlockInfo(DatanodeDescriptor[] targets) {
            this.targets = targets == null ? new ArrayList<DatanodeDescriptor>() : new ArrayList<DatanodeDescriptor>(Arrays.asList(targets));
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void setTimeStamp() {
            this.timeStamp = Time.monotonicNow();
        }

        void incrementReplicas(DatanodeDescriptor ... newTargets) {
            if (newTargets != null) {
                for (DatanodeDescriptor dn : newTargets) {
                    this.targets.add(dn);
                }
            }
        }

        void decrementReplicas(DatanodeDescriptor dn) {
            this.targets.remove(dn);
        }

        int getNumReplicas() {
            return this.targets.size();
        }
    }
}

