/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.datatransfer;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ReplaceDatanodeOnFailure {
    private final Policy policy;
    private final boolean bestEffort;

    public ReplaceDatanodeOnFailure(Policy policy, boolean bestEffort) {
        this.policy = policy;
        this.bestEffort = bestEffort;
    }

    public void checkEnabled() {
        if (this.policy == Policy.DISABLE) {
            throw new UnsupportedOperationException("This feature is disabled.  Please refer to dfs.client.block.write.replace-datanode-on-failure.enable configuration property.");
        }
    }

    public boolean isBestEffort() {
        return this.bestEffort;
    }

    public boolean satisfy(short replication, DatanodeInfo[] existings, boolean isAppend, boolean isHflushed) {
        int n;
        int n2 = n = existings == null ? 0 : existings.length;
        if (n == 0 || n >= replication) {
            return false;
        }
        return this.policy.getCondition().satisfy(replication, existings, n, isAppend, isHflushed);
    }

    public String toString() {
        return this.policy.toString();
    }

    public static ReplaceDatanodeOnFailure get(Configuration conf) {
        Policy policy = ReplaceDatanodeOnFailure.getPolicy(conf);
        boolean bestEffort = conf.getBoolean("dfs.client.block.write.replace-datanode-on-failure.best-effort", false);
        return new ReplaceDatanodeOnFailure(policy, bestEffort);
    }

    private static Policy getPolicy(Configuration conf) {
        boolean enabled = conf.getBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", true);
        if (!enabled) {
            return Policy.DISABLE;
        }
        String policy = conf.get("dfs.client.block.write.replace-datanode-on-failure.policy", "DEFAULT");
        for (int i = 1; i < Policy.values().length; ++i) {
            Policy p = Policy.values()[i];
            if (!p.name().equalsIgnoreCase(policy)) continue;
            return p;
        }
        throw new HadoopIllegalArgumentException("Illegal configuration value for dfs.client.block.write.replace-datanode-on-failure.policy: " + policy);
    }

    public static void write(Policy policy, boolean bestEffort, Configuration conf) {
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", policy != Policy.DISABLE);
        conf.set("dfs.client.block.write.replace-datanode-on-failure.policy", policy.name());
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.best-effort", bestEffort);
    }

    private static interface Condition {
        public static final Condition TRUE = new Condition(){

            @Override
            public boolean satisfy(short replication, DatanodeInfo[] existings, int nExistings, boolean isAppend, boolean isHflushed) {
                return true;
            }
        };
        public static final Condition FALSE = new Condition(){

            @Override
            public boolean satisfy(short replication, DatanodeInfo[] existings, int nExistings, boolean isAppend, boolean isHflushed) {
                return false;
            }
        };
        public static final Condition DEFAULT = new Condition(){

            @Override
            public boolean satisfy(short replication, DatanodeInfo[] existings, int n, boolean isAppend, boolean isHflushed) {
                if (replication < 3) {
                    return false;
                }
                if (n <= replication / 2) {
                    return true;
                }
                return isAppend || isHflushed;
            }
        };

        public boolean satisfy(short var1, DatanodeInfo[] var2, int var3, boolean var4, boolean var5);
    }

    public static enum Policy {
        DISABLE(Condition.FALSE),
        NEVER(Condition.FALSE),
        DEFAULT(Condition.DEFAULT),
        ALWAYS(Condition.TRUE);

        private final Condition condition;

        private Policy(Condition condition) {
            this.condition = condition;
        }

        Condition getCondition() {
            return this.condition;
        }
    }
}

