/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.datatransfer;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.datatransfer.BlockConstructionStage;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.token.Token;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.DataChecksum;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Span;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Trace;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.TraceInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.TraceScope;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DataTransferProtoUtil {
    static BlockConstructionStage fromProto(DataTransferProtos.OpWriteBlockProto.BlockConstructionStage stage) {
        return BlockConstructionStage.valueOf(stage.name());
    }

    static DataTransferProtos.OpWriteBlockProto.BlockConstructionStage toProto(BlockConstructionStage stage) {
        return DataTransferProtos.OpWriteBlockProto.BlockConstructionStage.valueOf(stage.name());
    }

    public static DataTransferProtos.ChecksumProto toProto(DataChecksum checksum) {
        HdfsProtos.ChecksumTypeProto type = PBHelper.convert(checksum.getChecksumType());
        return DataTransferProtos.ChecksumProto.newBuilder().setBytesPerChecksum(checksum.getBytesPerChecksum()).setType(type).build();
    }

    public static DataChecksum fromProto(DataTransferProtos.ChecksumProto proto) {
        if (proto == null) {
            return null;
        }
        int bytesPerChecksum = proto.getBytesPerChecksum();
        DataChecksum.Type type = PBHelper.convert(proto.getType());
        return DataChecksum.newDataChecksum(type, bytesPerChecksum);
    }

    static DataTransferProtos.ClientOperationHeaderProto buildClientHeader(ExtendedBlock blk, String client, Token<BlockTokenIdentifier> blockToken) {
        DataTransferProtos.ClientOperationHeaderProto header = DataTransferProtos.ClientOperationHeaderProto.newBuilder().setBaseHeader(DataTransferProtoUtil.buildBaseHeader(blk, blockToken)).setClientName(client).build();
        return header;
    }

    static DataTransferProtos.BaseHeaderProto buildBaseHeader(ExtendedBlock blk, Token<BlockTokenIdentifier> blockToken) {
        DataTransferProtos.BaseHeaderProto.Builder builder = DataTransferProtos.BaseHeaderProto.newBuilder().setBlock(PBHelper.convert(blk)).setToken(PBHelper.convert(blockToken));
        if (Trace.isTracing()) {
            Span s = Trace.currentSpan();
            builder.setTraceInfo(DataTransferProtos.DataTransferTraceInfoProto.newBuilder().setTraceId(s.getTraceId()).setParentId(s.getSpanId()));
        }
        return builder.build();
    }

    public static TraceInfo fromProto(DataTransferProtos.DataTransferTraceInfoProto proto) {
        if (proto == null) {
            return null;
        }
        if (!proto.hasTraceId()) {
            return null;
        }
        return new TraceInfo(proto.getTraceId(), proto.getParentId());
    }

    public static TraceScope continueTraceSpan(DataTransferProtos.ClientOperationHeaderProto header, String description) {
        return DataTransferProtoUtil.continueTraceSpan(header.getBaseHeader(), description);
    }

    public static TraceScope continueTraceSpan(DataTransferProtos.BaseHeaderProto header, String description) {
        return DataTransferProtoUtil.continueTraceSpan(header.getTraceInfo(), description);
    }

    public static TraceScope continueTraceSpan(DataTransferProtos.DataTransferTraceInfoProto proto, String description) {
        TraceScope scope = null;
        TraceInfo info = DataTransferProtoUtil.fromProto(proto);
        if (info != null) {
            scope = Trace.startSpan(description, info);
        }
        return scope;
    }

    public static void checkBlockOpStatus(DataTransferProtos.BlockOpResponseProto response, String logInfo) throws IOException {
        if (response.getStatus() != DataTransferProtos.Status.SUCCESS) {
            if (response.getStatus() == DataTransferProtos.Status.ERROR_ACCESS_TOKEN) {
                throw new InvalidBlockTokenException("Got access token error, status message " + response.getMessage() + ", " + logInfo);
            }
            throw new IOException("Got error, status message " + response.getMessage() + ", " + logInfo);
        }
    }
}

