/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol;

import java.util.Date;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RollingUpgradeInfo
extends RollingUpgradeStatus {
    private final long startTime;
    private long finalizeTime;
    private boolean createdRollbackImages;

    public RollingUpgradeInfo(String blockPoolId, boolean createdRollbackImages, long startTime, long finalizeTime) {
        super(blockPoolId, finalizeTime != 0L);
        this.createdRollbackImages = createdRollbackImages;
        this.startTime = startTime;
        this.finalizeTime = finalizeTime;
    }

    public boolean createdRollbackImages() {
        return this.createdRollbackImages;
    }

    public void setCreatedRollbackImages(boolean created) {
        this.createdRollbackImages = created;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isFinalized() {
        return this.finalizeTime != 0L;
    }

    public void finalize(long finalizeTime) {
        if (finalizeTime != 0L) {
            this.finalizeTime = finalizeTime;
            this.createdRollbackImages = false;
        }
    }

    public long getFinalizeTime() {
        return this.finalizeTime;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)this.startTime ^ (int)this.finalizeTime;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RollingUpgradeInfo)) {
            return false;
        }
        RollingUpgradeInfo that = (RollingUpgradeInfo)obj;
        return super.equals(that) && this.startTime == that.startTime && this.finalizeTime == that.finalizeTime;
    }

    @Override
    public String toString() {
        return super.toString() + "\n     Start Time: " + (this.startTime == 0L ? "<NOT STARTED>" : RollingUpgradeInfo.timestamp2String(this.startTime)) + "\n  Finalize Time: " + (this.finalizeTime == 0L ? "<NOT FINALIZED>" : RollingUpgradeInfo.timestamp2String(this.finalizeTime));
    }

    private static String timestamp2String(long timestamp) {
        return new Date(timestamp) + " (=" + timestamp + ")";
    }

    public static class Bean {
        private final String blockPoolId;
        private final long startTime;
        private final long finalizeTime;
        private final boolean createdRollbackImages;

        public Bean(RollingUpgradeInfo f) {
            this.blockPoolId = f.getBlockPoolId();
            this.startTime = f.startTime;
            this.finalizeTime = f.finalizeTime;
            this.createdRollbackImages = f.createdRollbackImages();
        }

        public String getBlockPoolId() {
            return this.blockPoolId;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getFinalizeTime() {
            return this.finalizeTime;
        }

        public boolean isCreatedRollbackImages() {
            return this.createdRollbackImages;
        }
    }
}

