/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol;

import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.StorageType;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaByStorageTypeExceededException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;
    protected StorageType type;

    public QuotaByStorageTypeExceededException() {
    }

    public QuotaByStorageTypeExceededException(String msg) {
        super(msg);
    }

    public QuotaByStorageTypeExceededException(long quota, long count, StorageType type) {
        super(quota, count);
        this.type = type;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            return "Quota by storage type : " + this.type.toString() + " on path : " + (this.pathName == null ? "" : this.pathName) + " is exceeded. quota = " + StringUtils.TraditionalBinaryPrefix.long2String(this.quota, "B", 2) + " but space consumed = " + StringUtils.TraditionalBinaryPrefix.long2String(this.count, "B", 2);
        }
        return msg;
    }
}

