/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.DFSUtil;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class HdfsConstants {
    public static final String CLIENT_NAMENODE_PROTOCOL_NAME = "org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol";
    public static final String CLIENT_DATANODE_PROTOCOL_NAME = "org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol";
    public static final int MIN_BLOCKS_FOR_WRITE = 1;
    public static final long QUOTA_DONT_SET = Long.MAX_VALUE;
    public static final long QUOTA_RESET = -1L;
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;
    public static final long LEASE_HARDLIMIT_PERIOD = 3600000L;
    public static final long LEASE_RECOVER_PERIOD = 10000L;
    public static final int MAX_PATH_LENGTH = 8000;
    public static final int MAX_PATH_DEPTH = 1000;
    public static final int DEFAULT_DATA_SOCKET_SIZE = 131072;
    public static final int IO_FILE_BUFFER_SIZE = new HdfsConfiguration().getInt("io.file.buffer.size", 4096);
    public static final int SMALL_BUFFER_SIZE = Math.min(IO_FILE_BUFFER_SIZE / 2, 512);
    public static final int BYTES_IN_INTEGER = 4;
    public static final long INVALID_TXID = -12345L;
    public static final long RESERVED_GENERATION_STAMPS_V1 = 0x10000000000L;
    public static final String HDFS_URI_SCHEME = "hdfs";
    public static final String HA_DT_SERVICE_PREFIX = "ha-";
    public static final String[] RESERVED_PATH_COMPONENTS = new String[]{".snapshot", ".reserved"};
    public static final int NAMENODE_LAYOUT_VERSION = NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION;
    public static final int DATANODE_LAYOUT_VERSION = DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION;
    public static final String DOT_SNAPSHOT_DIR = ".snapshot";
    public static final byte[] DOT_SNAPSHOT_DIR_BYTES = DFSUtil.string2Bytes(".snapshot");
    public static final String SEPARATOR_DOT_SNAPSHOT_DIR = "/.snapshot";
    public static final String SEPARATOR_DOT_SNAPSHOT_DIR_SEPARATOR = "/.snapshot/";
    public static final String MEMORY_STORAGE_POLICY_NAME = "LAZY_PERSIST";
    public static final String ALLSSD_STORAGE_POLICY_NAME = "ALL_SSD";
    public static final String ONESSD_STORAGE_POLICY_NAME = "ONE_SSD";
    public static final String HOT_STORAGE_POLICY_NAME = "HOT";
    public static final String WARM_STORAGE_POLICY_NAME = "WARM";
    public static final String COLD_STORAGE_POLICY_NAME = "COLD";
    public static final byte MEMORY_STORAGE_POLICY_ID = 15;
    public static final byte ALLSSD_STORAGE_POLICY_ID = 12;
    public static final byte ONESSD_STORAGE_POLICY_ID = 10;
    public static final byte HOT_STORAGE_POLICY_ID = 7;
    public static final byte WARM_STORAGE_POLICY_ID = 5;
    public static final byte COLD_STORAGE_POLICY_ID = 2;

    protected HdfsConstants() {
    }

    public static enum DatanodeReportType {
        ALL,
        LIVE,
        DEAD,
        DECOMMISSIONING;

    }

    public static enum RollingUpgradeAction {
        QUERY,
        PREPARE,
        FINALIZE;

        private static final Map<String, RollingUpgradeAction> MAP;

        public static RollingUpgradeAction fromString(String s) {
            return MAP.get(StringUtils.toUpperCase(s));
        }

        static {
            MAP = new HashMap<String, RollingUpgradeAction>();
            MAP.put("", QUERY);
            for (RollingUpgradeAction a : RollingUpgradeAction.values()) {
                MAP.put(a.name(), a);
            }
        }
    }

    public static enum SafeModeAction {
        SAFEMODE_LEAVE,
        SAFEMODE_ENTER,
        SAFEMODE_GET;

    }
}

