/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Sampler;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.Trace;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.TraceScope;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CachePoolIterator
extends BatchedRemoteIterator<String, CachePoolEntry> {
    private final ClientProtocol namenode;
    private final Sampler traceSampler;

    public CachePoolIterator(ClientProtocol namenode, Sampler traceSampler) {
        super("");
        this.namenode = namenode;
        this.traceSampler = traceSampler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> makeRequest(String prevKey) throws IOException {
        try (TraceScope scope = Trace.startSpan("listCachePools", this.traceSampler);){
            BatchedRemoteIterator.BatchedEntries<CachePoolEntry> batchedEntries = this.namenode.listCachePools(prevKey);
            return batchedEntries;
        }
    }

    @Override
    public String elementToPrevKey(CachePoolEntry entry) {
        return entry.getInfo().getPoolName();
    }
}

