/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.com.google.common.collect.Maps;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.NodeFencer;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.protocolPB.HAServiceProtocolClientSideTranslatorPB;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.ha.protocolPB.ZKFCProtocolClientSideTranslatorPB;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class HAServiceTarget {
    private static final String HOST_SUBST_KEY = "host";
    private static final String PORT_SUBST_KEY = "port";
    private static final String ADDRESS_SUBST_KEY = "address";

    public abstract InetSocketAddress getAddress();

    public abstract InetSocketAddress getZKFCAddress();

    public abstract NodeFencer getFencer();

    public abstract void checkFencingConfigured() throws BadFencingConfigurationException;

    public HAServiceProtocol getProxy(Configuration conf, int timeoutMs) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new HAServiceProtocolClientSideTranslatorPB(this.getAddress(), confCopy, factory, timeoutMs);
    }

    public ZKFCProtocol getZKFCProxy(Configuration conf, int timeoutMs) throws IOException {
        Configuration confCopy = new Configuration(conf);
        confCopy.setInt("ipc.client.connect.max.retries", 1);
        SocketFactory factory = NetUtils.getDefaultSocketFactory(confCopy);
        return new ZKFCProtocolClientSideTranslatorPB(this.getZKFCAddress(), confCopy, factory, timeoutMs);
    }

    public final Map<String, String> getFencingParameters() {
        HashMap<String, String> ret = Maps.newHashMap();
        this.addFencingParameters(ret);
        return ret;
    }

    protected void addFencingParameters(Map<String, String> ret) {
        ret.put(ADDRESS_SUBST_KEY, String.valueOf(this.getAddress()));
        ret.put(HOST_SUBST_KEY, this.getAddress().getHostName());
        ret.put(PORT_SUBST_KEY, String.valueOf(this.getAddress().getPort()));
    }

    public boolean isAutoFailoverEnabled() {
        return false;
    }
}

