/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FsStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.FsCommand;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.shell.PathData;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class FsUsage
extends FsCommand {
    protected boolean humanReadable = false;
    protected TableBuilder usagesTable;

    FsUsage() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Df.class, "-df");
        factory.addClass(Du.class, "-du");
        factory.addClass(Dus.class, "-dus");
    }

    protected String formatSize(long size) {
        return this.humanReadable ? StringUtils.TraditionalBinaryPrefix.long2String(size, "", 1) : String.valueOf(size);
    }

    private static class TableBuilder {
        protected boolean hasHeader = false;
        protected List<String[]> rows = new ArrayList<String[]>();
        protected int[] widths;
        protected boolean[] rightAlign;

        public TableBuilder(int columns) {
            this.widths = new int[columns];
            this.rightAlign = new boolean[columns];
        }

        public TableBuilder(Object ... headers) {
            this(headers.length);
            this.addRow(headers);
            this.hasHeader = true;
        }

        public void setRightAlign(int ... indexes) {
            for (int i : indexes) {
                this.rightAlign[i] = true;
            }
        }

        public void addRow(Object ... objects) {
            String[] row = new String[this.widths.length];
            for (int col = 0; col < this.widths.length; ++col) {
                row[col] = String.valueOf(objects[col]);
                this.widths[col] = Math.max(this.widths[col], row[col].length());
            }
            this.rows.add(row);
        }

        public void printToStream(PrintStream out) {
            if (this.isEmpty()) {
                return;
            }
            StringBuilder fmt = new StringBuilder();
            for (int i = 0; i < this.widths.length; ++i) {
                if (fmt.length() != 0) {
                    fmt.append("  ");
                }
                if (this.rightAlign[i]) {
                    fmt.append("%" + this.widths[i] + "s");
                    continue;
                }
                if (i != this.widths.length - 1) {
                    fmt.append("%-" + this.widths[i] + "s");
                    continue;
                }
                fmt.append("%s");
            }
            for (Object[] objectArray : this.rows) {
                out.println(String.format(fmt.toString(), objectArray));
            }
        }

        public int size() {
            return this.rows.size() - (this.hasHeader ? 1 : 0);
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    public static class Dus
    extends Du {
        public static final String NAME = "dus";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-s");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "du -s";
        }
    }

    public static class Du
    extends FsUsage {
        public static final String NAME = "du";
        public static final String USAGE = "[-s] [-h] <path> ...";
        public static final String DESCRIPTION = "Show the amount of space, in bytes, used by the files that match the specified file pattern. The following flags are optional:\n-s: Rather than showing the size of each individual file that matches the pattern, shows the total (summary) size.\n-h: Formats the sizes of files in a human-readable fashion rather than a number of bytes.\n\nNote that, even without the -s option, this only shows size summaries one level deep into a directory.\n\nThe output is in the form \n\tsize\tname(full path)\n";
        protected boolean summary = false;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "h", "s");
            cf.parse(args);
            this.humanReadable = cf.getOpt("h");
            this.summary = cf.getOpt("s");
            if (args.isEmpty()) {
                args.add(".");
            }
        }

        @Override
        protected void processPathArgument(PathData item) throws IOException {
            this.usagesTable = new TableBuilder(2);
            if (!this.summary && item.stat.isDirectory()) {
                this.recursePath(item);
            } else {
                super.processPathArgument(item);
            }
            this.usagesTable.printToStream(this.out);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            long length = item.stat.isDirectory() ? item.fs.getContentSummary(item.path).getLength() : item.stat.getLen();
            this.usagesTable.addRow(this.formatSize(length), item);
        }
    }

    public static class Df
    extends FsUsage {
        public static final String NAME = "df";
        public static final String USAGE = "[-h] [<path> ...]";
        public static final String DESCRIPTION = "Shows the capacity, free and used space of the filesystem. If the filesystem has multiple partitions, and no path to a particular partition is specified, then the status of the root partitions will be shown.\n-h: Formats the sizes of files in a human-readable fashion rather than a number of bytes.";

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, Integer.MAX_VALUE, "h");
            cf.parse(args);
            this.humanReadable = cf.getOpt("h");
            if (args.isEmpty()) {
                args.add("/");
            }
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            this.usagesTable = new TableBuilder("Filesystem", "Size", "Used", "Available", "Use%");
            this.usagesTable.setRightAlign(1, 2, 3, 4);
            super.processArguments(args);
            if (!this.usagesTable.isEmpty()) {
                this.usagesTable.printToStream(this.out);
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            FsStatus fsStats = item.fs.getStatus(item.path);
            long size = fsStats.getCapacity();
            long used = fsStats.getUsed();
            long free = fsStats.getRemaining();
            this.usagesTable.addRow(item.fs.getUri(), this.formatSize(size), this.formatSize(used), this.formatSize(free), StringUtils.formatPercent((double)used / (double)size, 0));
        }
    }
}

