/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.UmaskParser;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableFactories;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.WritableFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FsPermission
implements Writable {
    private static final Log LOG = LogFactory.getLog(FsPermission.class);
    static final WritableFactory FACTORY = new WritableFactory(){

        @Override
        public Writable newInstance() {
            return new FsPermission();
        }
    };
    public static final int MAX_PERMISSION_LENGTH = 10;
    private FsAction useraction = null;
    private FsAction groupaction = null;
    private FsAction otheraction = null;
    private boolean stickyBit = false;
    public static final String DEPRECATED_UMASK_LABEL = "dfs.umask";
    public static final String UMASK_LABEL = "fs.permissions.umask-mode";
    public static final int DEFAULT_UMASK = 18;
    private static final FsAction[] FSACTION_VALUES;

    public static FsPermission createImmutable(short permission) {
        return new ImmutableFsPermission(permission);
    }

    private FsPermission() {
    }

    public FsPermission(FsAction u, FsAction g, FsAction o) {
        this(u, g, o, false);
    }

    public FsPermission(FsAction u, FsAction g, FsAction o, boolean sb) {
        this.set(u, g, o, sb);
    }

    public FsPermission(short mode) {
        this.fromShort(mode);
    }

    public FsPermission(FsPermission other) {
        this.useraction = other.useraction;
        this.groupaction = other.groupaction;
        this.otheraction = other.otheraction;
        this.stickyBit = other.stickyBit;
    }

    public FsPermission(String mode) {
        this(new UmaskParser(mode).getUMask());
    }

    public FsAction getUserAction() {
        return this.useraction;
    }

    public FsAction getGroupAction() {
        return this.groupaction;
    }

    public FsAction getOtherAction() {
        return this.otheraction;
    }

    private void set(FsAction u, FsAction g, FsAction o, boolean sb) {
        this.useraction = u;
        this.groupaction = g;
        this.otheraction = o;
        this.stickyBit = sb;
    }

    public void fromShort(short n) {
        FsAction[] v = FSACTION_VALUES;
        this.set(v[n >>> 6 & 7], v[n >>> 3 & 7], v[n & 7], (n >>> 9 & 1) == 1);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeShort(this.toShort());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.fromShort(in.readShort());
    }

    public static FsPermission read(DataInput in) throws IOException {
        FsPermission p = new FsPermission();
        p.readFields(in);
        return p;
    }

    public short toShort() {
        int s = (this.stickyBit ? 512 : 0) | this.useraction.ordinal() << 6 | this.groupaction.ordinal() << 3 | this.otheraction.ordinal();
        return (short)s;
    }

    public short toExtendedShort() {
        return this.toShort();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FsPermission) {
            FsPermission that = (FsPermission)obj;
            return this.useraction == that.useraction && this.groupaction == that.groupaction && this.otheraction == that.otheraction && this.stickyBit == that.stickyBit;
        }
        return false;
    }

    public int hashCode() {
        return this.toShort();
    }

    public String toString() {
        String str = this.useraction.SYMBOL + this.groupaction.SYMBOL + this.otheraction.SYMBOL;
        if (this.stickyBit) {
            StringBuilder str2 = new StringBuilder(str);
            str2.replace(str2.length() - 1, str2.length(), this.otheraction.implies(FsAction.EXECUTE) ? "t" : "T");
            str = str2.toString();
        }
        return str;
    }

    public FsPermission applyUMask(FsPermission umask) {
        return new FsPermission(this.useraction.and(umask.useraction.not()), this.groupaction.and(umask.groupaction.not()), this.otheraction.and(umask.otheraction.not()));
    }

    public static FsPermission getUMask(Configuration conf) {
        int umask = 18;
        if (conf != null) {
            int oldUmask;
            block5: {
                String confUmask = conf.get(UMASK_LABEL);
                oldUmask = conf.getInt(DEPRECATED_UMASK_LABEL, Integer.MIN_VALUE);
                try {
                    if (confUmask != null) {
                        umask = new UmaskParser(confUmask).getUMask();
                    }
                }
                catch (IllegalArgumentException iae) {
                    String type = iae instanceof NumberFormatException ? "decimal" : "octal or symbolic";
                    String error = "Unable to parse configuration fs.permissions.umask-mode with value " + confUmask + " as " + type + " umask.";
                    LOG.warn(error);
                    if (oldUmask != Integer.MIN_VALUE) break block5;
                    throw new IllegalArgumentException(error);
                }
            }
            if (oldUmask != Integer.MIN_VALUE && umask != oldUmask) {
                LOG.warn("dfs.umask configuration key is deprecated. Convert to fs.permissions.umask-mode, using octal or symbolic umask specifications.");
                umask = oldUmask;
            }
        }
        return new FsPermission((short)umask);
    }

    public boolean getStickyBit() {
        return this.stickyBit;
    }

    public boolean getAclBit() {
        return false;
    }

    public boolean getEncryptedBit() {
        return false;
    }

    public static void setUMask(Configuration conf, FsPermission umask) {
        conf.set(UMASK_LABEL, String.format("%1$03o", umask.toShort()));
        conf.setInt(DEPRECATED_UMASK_LABEL, umask.toShort());
    }

    public static FsPermission getDefault() {
        return new FsPermission(511);
    }

    public static FsPermission getDirDefault() {
        return new FsPermission(511);
    }

    public static FsPermission getFileDefault() {
        return new FsPermission(438);
    }

    public static FsPermission getCachePoolDefault() {
        return new FsPermission(493);
    }

    public static FsPermission valueOf(String unixSymbolicPermission) {
        if (unixSymbolicPermission == null) {
            return null;
        }
        if (unixSymbolicPermission.length() != 10) {
            throw new IllegalArgumentException(String.format("length != %d(unixSymbolicPermission=%s)", 10, unixSymbolicPermission));
        }
        int n = 0;
        for (int i = 1; i < unixSymbolicPermission.length(); ++i) {
            n <<= 1;
            char c = unixSymbolicPermission.charAt(i);
            n += c == '-' || c == 'T' || c == 'S' ? 0 : 1;
        }
        if (unixSymbolicPermission.charAt(9) == 't' || unixSymbolicPermission.charAt(9) == 'T') {
            n += 512;
        }
        return new FsPermission((short)n);
    }

    static {
        WritableFactories.setFactory(FsPermission.class, FACTORY);
        WritableFactories.setFactory(ImmutableFsPermission.class, FACTORY);
        FSACTION_VALUES = FsAction.values();
    }

    private static class ImmutableFsPermission
    extends FsPermission {
        public ImmutableFsPermission(short permission) {
            super(permission);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

