/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.crypto.key;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.crypto.key.KeyProvider;

public abstract class KeyProviderExtension<E extends Extension>
extends KeyProvider {
    private KeyProvider keyProvider;
    private E extension;

    public KeyProviderExtension(KeyProvider keyProvider, E extensions) {
        super(keyProvider.getConf());
        this.keyProvider = keyProvider;
        this.extension = extensions;
    }

    protected E getExtension() {
        return this.extension;
    }

    protected KeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    public boolean isTransient() {
        return this.keyProvider.isTransient();
    }

    @Override
    public KeyProvider.Metadata[] getKeysMetadata(String ... names) throws IOException {
        return this.keyProvider.getKeysMetadata(names);
    }

    @Override
    public KeyProvider.KeyVersion getCurrentKey(String name) throws IOException {
        return this.keyProvider.getCurrentKey(name);
    }

    @Override
    public KeyProvider.KeyVersion createKey(String name, KeyProvider.Options options) throws NoSuchAlgorithmException, IOException {
        return this.keyProvider.createKey(name, options);
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        return this.keyProvider.rollNewVersion(name);
    }

    @Override
    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        return this.keyProvider.getKeyVersion(versionName);
    }

    @Override
    public List<String> getKeys() throws IOException {
        return this.keyProvider.getKeys();
    }

    @Override
    public List<KeyProvider.KeyVersion> getKeyVersions(String name) throws IOException {
        return this.keyProvider.getKeyVersions(name);
    }

    @Override
    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        return this.keyProvider.getMetadata(name);
    }

    @Override
    public KeyProvider.KeyVersion createKey(String name, byte[] material, KeyProvider.Options options) throws IOException {
        return this.keyProvider.createKey(name, material, options);
    }

    @Override
    public void deleteKey(String name) throws IOException {
        this.keyProvider.deleteKey(name);
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        return this.keyProvider.rollNewVersion(name, material);
    }

    @Override
    public void flush() throws IOException {
        this.keyProvider.flush();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.keyProvider.toString();
    }

    public static interface Extension {
    }
}

