/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality;

import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Ordering;
import org.apache.flink.fs.s3presto.shaded.com.google.common.primitives.Ints;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.BasicSliceInput;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.DynamicSliceOutput;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.DenseHll;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.Format;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.HllInstance;
import org.apache.flink.fs.s3presto.shaded.io.airlift.stats.cardinality.Utils;
import org.apache.flink.fs.s3presto.shaded.org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
final class SparseHll
implements HllInstance {
    private static final int SPARSE_INSTANCE_SIZE = ClassLayout.parseClass(SparseHll.class).instanceSize();
    private static final int VALUE_BITS = 6;
    private static final int VALUE_MASK = 63;
    private static final int EXTENDED_PREFIX_BITS = 26;
    private final byte indexBitLength;
    private short numberOfEntries;
    private int[] entries;

    public SparseHll(int indexBitLength) {
        SparseHll.validatePrefixLength(indexBitLength);
        this.indexBitLength = (byte)indexBitLength;
        this.entries = new int[1];
    }

    public SparseHll(Slice serialized) {
        BasicSliceInput input = serialized.getInput();
        Preconditions.checkArgument(input.readByte() == Format.SPARSE_V2.getTag(), "invalid format tag");
        this.indexBitLength = input.readByte();
        SparseHll.validatePrefixLength(this.indexBitLength);
        this.numberOfEntries = input.readShort();
        this.entries = new int[this.numberOfEntries];
        for (int i = 0; i < this.numberOfEntries; ++i) {
            this.entries[i] = input.readInt();
        }
        Preconditions.checkArgument(!input.isReadable(), "input is too big");
    }

    public static boolean canDeserialize(Slice serialized) {
        return serialized.getByte(0) == Format.SPARSE_V2.getTag();
    }

    @Override
    public void insertHash(long hash) {
        int bucket = Utils.computeIndex(hash, 26);
        int position = this.searchBucket(bucket);
        if (position < 0) {
            int insertionPoint;
            if (this.numberOfEntries + 1 > this.entries.length) {
                this.entries = Arrays.copyOf(this.entries, this.entries.length + 10);
            }
            if ((insertionPoint = -(position + 1)) < this.numberOfEntries) {
                System.arraycopy(this.entries, insertionPoint, this.entries, insertionPoint + 1, this.numberOfEntries - insertionPoint);
            }
            this.entries[insertionPoint] = this.encode(hash);
            this.numberOfEntries = (short)(this.numberOfEntries + 1);
        } else {
            int currentEntry = this.entries[position];
            int newValue = Utils.numberOfLeadingZeros(hash, 26);
            if (SparseHll.decodeBucketValue(currentEntry) < newValue) {
                this.entries[position] = SparseHll.encode(bucket, newValue);
            }
        }
    }

    private int encode(long hash) {
        return SparseHll.encode(Utils.computeIndex(hash, 26), Utils.numberOfLeadingZeros(hash, 26));
    }

    private static int encode(int bucketIndex, int value) {
        return bucketIndex << 6 | value;
    }

    private static int decodeBucketIndex(int entry) {
        return SparseHll.decodeBucketIndex(26, entry);
    }

    private static int decodeBucketValue(int entry) {
        return entry & 0x3F;
    }

    private static int decodeBucketIndex(int indexBitLength, int entry) {
        return entry >>> 32 - indexBitLength;
    }

    public void mergeWith(SparseHll other) {
        this.entries = this.mergeEntries(other);
        this.numberOfEntries = (short)this.entries.length;
    }

    @Override
    public DenseHll toDense() {
        DenseHll result = new DenseHll(this.indexBitLength);
        for (int i = 0; i < this.numberOfEntries; ++i) {
            int bits;
            int entry = this.entries[i];
            int bucket = SparseHll.decodeBucketIndex(this.indexBitLength, entry);
            int zeros = Integer.numberOfLeadingZeros(entry << this.indexBitLength);
            if (zeros > (bits = 26 - this.indexBitLength)) {
                zeros = bits + SparseHll.decodeBucketValue(entry);
            }
            result.insert(bucket, zeros + 1);
        }
        return result;
    }

    @Override
    public long cardinality() {
        int totalBuckets = Utils.numberOfBuckets(26);
        int zeroBuckets = totalBuckets - this.numberOfEntries;
        return Math.round(Utils.linearCounting(zeroBuckets, totalBuckets));
    }

    @Override
    public int estimatedInMemorySize() {
        return SPARSE_INSTANCE_SIZE + 4 * this.numberOfEntries;
    }

    @Override
    public int getIndexBitLength() {
        return this.indexBitLength;
    }

    private int searchBucket(int bucketIndex) {
        int low = 0;
        int high = this.numberOfEntries - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            int middleBucketIndex = SparseHll.decodeBucketIndex(this.entries[middle]);
            if (bucketIndex > middleBucketIndex) {
                low = middle + 1;
                continue;
            }
            if (bucketIndex < middleBucketIndex) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        return -(low + 1);
    }

    private int[] mergeEntries(SparseHll other) {
        int[] result = new int[this.numberOfEntries + other.numberOfEntries];
        int leftIndex = 0;
        int rightIndex = 0;
        int index = 0;
        while (leftIndex < this.numberOfEntries && rightIndex < other.numberOfEntries) {
            int right;
            int left = SparseHll.decodeBucketIndex(this.entries[leftIndex]);
            if (left < (right = SparseHll.decodeBucketIndex(other.entries[rightIndex]))) {
                result[index++] = this.entries[leftIndex++];
                continue;
            }
            if (left > right) {
                result[index++] = other.entries[rightIndex++];
                continue;
            }
            int value = Math.max(SparseHll.decodeBucketValue(this.entries[leftIndex]), SparseHll.decodeBucketValue(other.entries[rightIndex]));
            result[index++] = SparseHll.encode(left, value);
            ++leftIndex;
            ++rightIndex;
        }
        while (leftIndex < this.numberOfEntries) {
            result[index++] = this.entries[leftIndex++];
        }
        while (rightIndex < other.numberOfEntries) {
            result[index++] = other.entries[rightIndex++];
        }
        return Arrays.copyOf(result, index);
    }

    @Override
    public Slice serialize() {
        int size = 4 + 4 * this.numberOfEntries;
        DynamicSliceOutput out = new DynamicSliceOutput(size).appendByte(Format.SPARSE_V2.getTag()).appendByte(this.indexBitLength).appendShort(this.numberOfEntries);
        for (int i = 0; i < this.numberOfEntries; ++i) {
            out.appendInt(this.entries[i]);
        }
        return out.slice();
    }

    @Override
    public int estimatedSerializedSize() {
        return 5 + 4 * this.numberOfEntries;
    }

    private static void validatePrefixLength(int indexBitLength) {
        Preconditions.checkArgument(indexBitLength >= 1 && indexBitLength <= 26, "indexBitLength is out of range");
    }

    @Override
    @VisibleForTesting
    public void verify() {
        Preconditions.checkState(this.numberOfEntries <= this.entries.length, "Expected number of hashes (%s) larger than array length (%s)", (int)this.numberOfEntries, this.entries.length);
        Preconditions.checkState(Ordering.from(Comparator.comparingInt(e -> SparseHll.decodeBucketIndex((Integer)e))).isOrdered(Ints.asList(Arrays.copyOf(this.entries, (int)this.numberOfEntries))), "entries are not sorted");
    }
}

