/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.configuration;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Provider;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigurationBinding;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigurationFactory;

class ConfigurationProvider<T>
implements Provider<T> {
    private final ConfigurationBinding<T> configurationBinding;
    private ConfigurationFactory configurationFactory;
    private Optional<Object> bindingSource;

    public ConfigurationProvider(ConfigurationBinding<T> configurationBinding) {
        this.configurationBinding = Objects.requireNonNull(configurationBinding, "configurationBinding is null");
    }

    @Inject
    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public ConfigurationBinding<T> getConfigurationBinding() {
        return this.configurationBinding;
    }

    public Optional<Object> getBindingSource() {
        return this.bindingSource;
    }

    public void setBindingSource(Optional<Object> bindingSource) {
        this.bindingSource = bindingSource;
    }

    public T get() {
        Objects.requireNonNull(this.configurationFactory, "configurationFactory");
        return this.configurationFactory.build(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationProvider that = (ConfigurationProvider)o;
        return Objects.equals(this.configurationBinding, that.configurationBinding);
    }

    public int hashCode() {
        return Objects.hash(this.configurationBinding);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configurationBinding", this.configurationBinding).toString();
    }
}

