/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableSortedMap;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Maps;

public class ConfigurationLoader {
    public Map<String, String> loadProperties() throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        String configFile = System.getProperty("config");
        if (configFile != null) {
            result.putAll(this.loadPropertiesFrom(configFile));
        }
        result.putAll(this.getSystemProperties());
        return ImmutableSortedMap.copyOf(result);
    }

    public Map<String, String> loadPropertiesFrom(String path) throws IOException {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(new File(path));){
            properties.load(reader);
        }
        return Maps.fromProperties(properties);
    }

    public Map<String, String> getSystemProperties() {
        return Maps.fromProperties(System.getProperties());
    }
}

