/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.DecimalUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import parquet.column.ColumnDescriptor;
import parquet.schema.PrimitiveType;

public class ParquetShortDecimalColumnReader
extends ParquetColumnReader {
    ParquetShortDecimalColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            long decimalValue = this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32) ? (long)this.valuesReader.readInteger() : (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64) ? this.valuesReader.readLong() : DecimalUtils.getShortDecimalValue(this.valuesReader.readBytes().getBytes()));
            type.writeLong(blockBuilder, decimalValue);
        } else {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                this.valuesReader.readInteger();
            } else if (this.columnDescriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
                this.valuesReader.readLong();
            } else {
                this.valuesReader.readBytes();
            }
        }
    }
}

