/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetCorruptionException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTypeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetValidationUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.RichColumnDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.memory.AggregatedMemoryContext;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.memory.LocalMemoryContext;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnChunk;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnChunkDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.ArrayBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.RowBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.RunLengthEncodedBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.MapType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.NamedTypeSignature;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeSignatureParameter;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import parquet.column.ColumnDescriptor;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.io.PrimitiveColumnIO;
import parquet.schema.MessageType;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final String MAP_TYPE_NAME = "map";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private static final String ARRAY_TYPE_NAME = "bag";
    private static final String ARRAY_ELEMENT_NAME = "array_element";
    private final MessageType fileSchema;
    private final MessageType requestedSchema;
    private final List<BlockMetaData> blocks;
    private final ParquetDataSource dataSource;
    private final TypeManager typeManager;
    private int currentBlock;
    private BlockMetaData currentBlockMetadata;
    private long currentPosition;
    private long currentGroupRowCount;
    private long nextRowInGroup;
    private int batchSize;
    private final Map<ColumnDescriptor, ParquetColumnReader> columnReadersMap = new HashMap<ColumnDescriptor, ParquetColumnReader>();
    private AggregatedMemoryContext currentRowGroupMemoryContext;
    private final AggregatedMemoryContext systemMemoryContext;

    public ParquetReader(MessageType fileSchema, MessageType requestedSchema, List<BlockMetaData> blocks, ParquetDataSource dataSource, TypeManager typeManager, AggregatedMemoryContext systemMemoryContext) {
        this.fileSchema = fileSchema;
        this.requestedSchema = requestedSchema;
        this.blocks = blocks;
        this.dataSource = dataSource;
        this.typeManager = typeManager;
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.currentRowGroupMemoryContext = systemMemoryContext.newAggregatedMemoryContext();
        this.initializeColumnReaders();
    }

    @Override
    public void close() throws IOException {
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.toIntExact(Math.min(1024L, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        this.currentPosition += (long)this.batchSize;
        for (PrimitiveColumnIO columnIO : ParquetTypeUtils.getColumns(this.fileSchema, this.requestedSchema)) {
            ColumnDescriptor descriptor = columnIO.getColumnDescriptor();
            RichColumnDescriptor column = new RichColumnDescriptor(descriptor.getPath(), columnIO.getType().asPrimitiveType(), descriptor.getMaxRepetitionLevel(), descriptor.getMaxDefinitionLevel());
            ParquetColumnReader columnReader = this.columnReadersMap.get((Object)column);
            columnReader.prepareNextRead(this.batchSize);
        }
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.systemMemoryContext.newAggregatedMemoryContext();
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        ++this.currentBlock;
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.columnReadersMap.clear();
        this.initializeColumnReaders();
        return true;
    }

    public Block readArray(Type type, List<String> path) throws IOException {
        return this.readArray(type, path, (IntList)new IntArrayList());
    }

    private Block readArray(Type type, List<String> path, IntList elementOffsets) throws IOException {
        List parameters = type.getTypeParameters();
        Preconditions.checkArgument(parameters.size() == 1, "Arrays must have a single type parameter, found %d", parameters.size());
        path.add(ARRAY_TYPE_NAME);
        Type elementType = (Type)parameters.get(0);
        Block block = this.readBlock(ARRAY_ELEMENT_NAME, elementType, path, elementOffsets);
        path.remove(ARRAY_TYPE_NAME);
        if (elementOffsets.isEmpty()) {
            for (int i = 0; i < this.batchSize; ++i) {
                elementOffsets.add(0);
            }
            return RunLengthEncodedBlock.create((Type)elementType, null, (int)this.batchSize);
        }
        int[] offsets = new int[this.batchSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            offsets[i] = offsets[i - 1] + elementOffsets.getInt(i - 1);
        }
        return new ArrayBlock(this.batchSize, new boolean[this.batchSize], offsets, block);
    }

    public Block readMap(Type type, List<String> path) throws IOException {
        return this.readMap(type, path, (IntList)new IntArrayList());
    }

    private Block readMap(Type type, List<String> path, IntList elementOffsets) throws IOException {
        List parameters = type.getTypeParameters();
        Preconditions.checkArgument(parameters.size() == 2, "Maps must have two type parameters, found %d", parameters.size());
        Block[] blocks = new Block[parameters.size()];
        IntArrayList keyOffsets = new IntArrayList();
        IntArrayList valueOffsets = new IntArrayList();
        path.add(MAP_TYPE_NAME);
        blocks[0] = this.readBlock(MAP_KEY_NAME, (Type)parameters.get(0), path, (IntList)keyOffsets);
        blocks[1] = this.readBlock(MAP_VALUE_NAME, (Type)parameters.get(1), path, (IntList)valueOffsets);
        path.remove(MAP_TYPE_NAME);
        if (blocks[0].getPositionCount() == 0) {
            for (int i = 0; i < this.batchSize; ++i) {
                elementOffsets.add(0);
            }
            return RunLengthEncodedBlock.create((Type)((Type)parameters.get(0)), null, (int)this.batchSize);
        }
        int[] offsets = new int[this.batchSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            int elementPositionCount = keyOffsets.getInt(i - 1);
            elementOffsets.add(elementPositionCount * 2);
            offsets[i] = offsets[i - 1] + elementPositionCount;
        }
        return ((MapType)type).createBlockFromKeyValue(new boolean[this.batchSize], offsets, blocks[0], blocks[1]);
    }

    public Block readStruct(Type type, List<String> path) throws IOException {
        return this.readStruct(type, path, (IntList)new IntArrayList());
    }

    private Block readStruct(Type type, List<String> path, IntList elementOffsets) throws IOException {
        List parameters = type.getTypeSignature().getParameters();
        Block[] blocks = new Block[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            NamedTypeSignature namedTypeSignature = ((TypeSignatureParameter)parameters.get(i)).getNamedTypeSignature();
            Type fieldType = this.typeManager.getType(namedTypeSignature.getTypeSignature());
            String name = namedTypeSignature.getName();
            blocks[i] = this.readBlock(name, fieldType, path, (IntList)new IntArrayList());
        }
        int blockSize = blocks[0].getPositionCount();
        int[] offsets = new int[blockSize + 1];
        for (int i = 1; i < offsets.length; ++i) {
            elementOffsets.add(parameters.size());
            offsets[i] = i;
        }
        return new RowBlock(0, blockSize, new boolean[blockSize], offsets, blocks);
    }

    public Block readPrimitive(ColumnDescriptor columnDescriptor, Type type) throws IOException {
        return this.readPrimitive(columnDescriptor, type, (IntList)new IntArrayList());
    }

    private Block readPrimitive(ColumnDescriptor columnDescriptor, Type type, IntList offsets) throws IOException {
        ParquetColumnReader columnReader = this.columnReadersMap.get(columnDescriptor);
        if (columnReader.getPageReader() == null) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = metadata.getStartingPos();
            int totalSize = Math.toIntExact(metadata.getTotalSize());
            byte[] buffer = this.allocateBlock(totalSize);
            this.dataSource.readFully(startingPosition, buffer);
            ParquetColumnChunkDescriptor descriptor = new ParquetColumnChunkDescriptor(columnDescriptor, metadata, totalSize);
            ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, buffer, 0);
            columnReader.setPageReader(columnChunk.readAllPages());
        }
        return columnReader.readPrimitive(type, offsets);
    }

    private byte[] allocateBlock(int length) {
        byte[] buffer = new byte[length];
        LocalMemoryContext blockMemoryContext = this.currentRowGroupMemoryContext.newLocalMemoryContext();
        blockMemoryContext.setBytes(buffer.length);
        return buffer;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : ParquetTypeUtils.getColumns(this.fileSchema, this.requestedSchema)) {
            ColumnDescriptor descriptor = columnIO.getColumnDescriptor();
            RichColumnDescriptor column = new RichColumnDescriptor(descriptor.getPath(), columnIO.getType().asPrimitiveType(), descriptor.getMaxRepetitionLevel(), descriptor.getMaxDefinitionLevel());
            this.columnReadersMap.put(column, ParquetColumnReader.createReader(column));
        }
    }

    private Block readBlock(String name, Type type, List<String> path, IntList offsets) throws IOException {
        path.add(name);
        Optional<RichColumnDescriptor> descriptor = ParquetTypeUtils.getDescriptor(this.fileSchema, this.requestedSchema, path);
        if (!descriptor.isPresent()) {
            path.remove(name);
            return RunLengthEncodedBlock.create((Type)type, null, (int)this.batchSize);
        }
        Block block = "row".equals(type.getTypeSignature().getBase()) ? this.readStruct(type, path, offsets) : (MAP_TYPE_NAME.equals(type.getTypeSignature().getBase()) ? this.readMap(type, path, offsets) : ("array".equals(type.getTypeSignature().getBase()) ? this.readArray(type, path, offsets) : this.readPrimitive(descriptor.get(), type, offsets)));
        path.remove(name);
        return block;
    }
}

