/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetCompressionUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPage;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPageV1;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPageV2;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import parquet.hadoop.metadata.CompressionCodecName;

class ParquetPageReader {
    private final CompressionCodecName codec;
    private final long valueCount;
    private final List<ParquetDataPage> compressedPages;
    private final ParquetDictionaryPage compressedDictionaryPage;

    public ParquetPageReader(CompressionCodecName codec, List<ParquetDataPage> compressedPages, ParquetDictionaryPage compressedDictionaryPage) {
        this.codec = codec;
        this.compressedPages = new LinkedList<ParquetDataPage>(compressedPages);
        this.compressedDictionaryPage = compressedDictionaryPage;
        int count = 0;
        for (ParquetDataPage page : compressedPages) {
            count += page.getValueCount();
        }
        this.valueCount = count;
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public ParquetDataPage readPage() {
        if (this.compressedPages.isEmpty()) {
            return null;
        }
        ParquetDataPage compressedPage = this.compressedPages.remove(0);
        try {
            if (compressedPage instanceof ParquetDataPageV1) {
                ParquetDataPageV1 dataPageV1 = (ParquetDataPageV1)compressedPage;
                return new ParquetDataPageV1(ParquetCompressionUtils.decompress(this.codec, dataPageV1.getSlice(), dataPageV1.getUncompressedSize()), dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getStatistics(), dataPageV1.getRepetitionLevelEncoding(), dataPageV1.getDefinitionLevelEncoding(), dataPageV1.getValueEncoding());
            }
            ParquetDataPageV2 dataPageV2 = (ParquetDataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = Math.toIntExact(dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().length() - dataPageV2.getRepetitionLevels().length());
            return new ParquetDataPageV2(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), ParquetCompressionUtils.decompress(this.codec, dataPageV2.getSlice(), uncompressedSize), dataPageV2.getUncompressedSize(), dataPageV2.getStatistics(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public ParquetDictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            return new ParquetDictionaryPage(ParquetCompressionUtils.decompress(this.codec, this.compressedDictionaryPage.getSlice(), this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }
}

