/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Chars;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Varchars;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import parquet.column.ColumnDescriptor;
import parquet.io.api.Binary;

public class ParquetBinaryColumnReader
extends ParquetColumnReader {
    public ParquetBinaryColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            Slice value = binary.length() == 0 ? Slices.EMPTY_SLICE : Slices.wrappedBuffer(binary.getBytes());
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            if (Chars.isCharType((Type)type)) {
                value = Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
            }
            type.writeSlice(blockBuilder, value);
        } else {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

