/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketProperty;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.StorageFormat;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;

@Immutable
public class Storage {
    private final StorageFormat storageFormat;
    private final String location;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final boolean sorted;
    private final boolean skewed;
    private final Map<String, String> serdeParameters;

    public Storage(@JsonProperty(value="storageFormat") StorageFormat storageFormat, @JsonProperty(value="location") String location, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="sorted") boolean sorted, @JsonProperty(value="skewed") boolean skewed, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters) {
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.sorted = sorted;
        this.skewed = skewed;
        this.serdeParameters = ImmutableMap.copyOf(Objects.requireNonNull(serdeParameters, "serdeParameters is null"));
    }

    @JsonProperty
    public StorageFormat getStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public boolean isSorted() {
        return this.sorted;
    }

    @JsonProperty
    public boolean isSkewed() {
        return this.skewed;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Storage storage) {
        return new Builder(storage);
    }

    public static class Builder {
        private StorageFormat storageFormat;
        private String location;
        private Optional<HiveBucketProperty> bucketProperty = Optional.empty();
        private boolean sorted = false;
        private boolean skewed = false;
        private Map<String, String> serdeParameters = ImmutableMap.of();

        private Builder() {
        }

        private Builder(Storage storage) {
            this.storageFormat = storage.storageFormat;
            this.location = storage.location;
            this.bucketProperty = storage.bucketProperty;
            this.sorted = storage.sorted;
            this.skewed = storage.skewed;
            this.serdeParameters = storage.serdeParameters;
        }

        public Builder setStorageFormat(StorageFormat storageFormat) {
            this.storageFormat = storageFormat;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setBucketProperty(Optional<HiveBucketProperty> bucketProperty) {
            this.bucketProperty = bucketProperty;
            return this;
        }

        public Builder setSorted(boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        public Builder setSkewed(boolean skewed) {
            this.skewed = skewed;
            return this;
        }

        public Builder setSerdeParameters(Map<String, String> serdeParameters) {
            this.serdeParameters = serdeParameters;
            return this;
        }

        public Storage build() {
            return new Storage(this.storageFormat, this.location, this.bucketProperty, this.sorted, this.skewed, this.serdeParameters);
        }
    }
}

