/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Partition;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Table;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.SchemaTableName;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;

public class HivePageSinkMetadata {
    private final SchemaTableName schemaTableName;
    private final Optional<Table> table;
    private final Map<List<String>, Optional<Partition>> modifiedPartitions;

    public HivePageSinkMetadata(SchemaTableName schemaTableName, Optional<Table> table, Map<List<String>, Optional<Partition>> modifiedPartitions) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.modifiedPartitions = Objects.requireNonNull(modifiedPartitions, "modifiedPartitions is null");
        Preconditions.checkArgument(table.isPresent() && !table.get().getPartitionColumns().isEmpty() || modifiedPartitions.isEmpty());
    }

    @JsonCreator
    public static HivePageSinkMetadata deserialize(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="table") Optional<Table> table, @JsonProperty(value="modifiedPartitions") List<JsonSerializableEntry<List<String>, Optional<Partition>>> modifiedPartitions) {
        Objects.requireNonNull(modifiedPartitions, "modifiedPartitions is null");
        return new HivePageSinkMetadata(schemaTableName, table, JsonSerializableEntry.toMap(modifiedPartitions));
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public Optional<Table> getTable() {
        return this.table;
    }

    @JsonProperty(value="modifiedPartitions")
    public List<JsonSerializableEntry<List<String>, Optional<Partition>>> getJsonSerializableModifiedPartitions() {
        return JsonSerializableEntry.fromMap(this.modifiedPartitions);
    }

    public Map<List<String>, Optional<Partition>> getModifiedPartitions() {
        return this.modifiedPartitions;
    }

    public static class JsonSerializableEntry<K, V> {
        private final K key;
        private final V value;

        @JsonCreator
        public JsonSerializableEntry(@JsonProperty(value="key") K key, @JsonProperty(value="value") V value) {
            this.key = key;
            this.value = value;
        }

        @JsonProperty
        public K getKey() {
            return this.key;
        }

        @JsonProperty
        public V getValue() {
            return this.value;
        }

        public static <K, V> List<JsonSerializableEntry<K, V>> fromMap(Map<K, V> map) {
            return map.entrySet().stream().map(entry -> new JsonSerializableEntry(entry.getKey(), entry.getValue())).collect(Collectors.toList());
        }

        public static <K, V> Map<K, V> toMap(List<JsonSerializableEntry<K, V>> list) {
            return list.stream().collect(Collectors.toMap(JsonSerializableEntry::getKey, JsonSerializableEntry::getValue));
        }
    }
}

