/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForCachingHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Database;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HiveColumnStatistics;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Partition;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.PrincipalPrivileges;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Table;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.cache.CacheBuilder;
import org.apache.flink.fs.s3presto.shaded.com.google.common.cache.CacheLoader;
import org.apache.flink.fs.s3presto.shaded.com.google.common.cache.LoadingCache;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Iterables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Streams;
import org.apache.flink.fs.s3presto.shaded.com.google.common.util.concurrent.ExecutionError;
import org.apache.flink.fs.s3presto.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.flink.fs.s3presto.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements ExtendedHiveMetastore {
    protected final ExtendedHiveMetastore delegate;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<HiveTableName, Optional<Table>> tableCache;
    private final LoadingCache<String, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<TableColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> tableColumnStatisticsCache;
    private final LoadingCache<PartitionColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> partitionColumnStatisticsCache;
    private final LoadingCache<String, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<HivePartitionName, Optional<Partition>> partitionCache;
    private final LoadingCache<PartitionFilter, Optional<List<String>>> partitionFilterCache;
    private final LoadingCache<HiveTableName, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<String, Set<String>> userRolesCache;
    private final LoadingCache<UserTableKey, Set<HivePrivilegeInfo>> userTablePrivileges;

    @Inject
    public CachingHiveMetastore(@ForCachingHiveMetastore ExtendedHiveMetastore delegate, @ForCachingHiveMetastore ExecutorService executor, HiveClientConfig hiveClientConfig) {
        this(delegate, executor, hiveClientConfig.getMetastoreCacheTtl(), hiveClientConfig.getMetastoreRefreshInterval(), hiveClientConfig.getMetastoreCacheMaximumSize());
    }

    public CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, Duration cacheTtl, Duration refreshInterval, long maximumSize) {
        this(delegate, executor, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.toMillis() >= cacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(refreshInterval.toMillis()), maximumSize);
    }

    public static CachingHiveMetastore memoizeMetastore(ExtendedHiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, (ExecutorService)MoreExecutors.newDirectExecutorService(), OptionalLong.empty(), OptionalLong.empty(), maximumSize);
    }

    private CachingHiveMetastore(ExtendedHiveMetastore delegate, ExecutorService executor, OptionalLong expiresAfterWriteMillis, OptionalLong refreshMills, long maximumSize) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.databaseNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<String, List<String>>(){

            @Override
            public List<String> load(String key) throws Exception {
                return CachingHiveMetastore.this.loadAllDatabases();
            }
        }, executor));
        this.databaseCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<String, Optional<Database>>(){

            @Override
            public Optional<Database> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadDatabase(databaseName);
            }
        }, executor));
        this.tableNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<String, Optional<List<String>>>(){

            @Override
            public Optional<List<String>> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllTables(databaseName);
            }
        }, executor));
        this.tableColumnStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<TableColumnStatisticsCacheKey, Optional<HiveColumnStatistics>>(){

            @Override
            public Optional<HiveColumnStatistics> load(TableColumnStatisticsCacheKey key) throws Exception {
                return this.loadAll((Iterable<? extends TableColumnStatisticsCacheKey>)ImmutableList.of(key)).get(key);
            }

            @Override
            public Map<TableColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> loadAll(Iterable<? extends TableColumnStatisticsCacheKey> keys) throws Exception {
                return CachingHiveMetastore.this.loadColumnStatistics(keys);
            }
        }, executor));
        this.partitionColumnStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<PartitionColumnStatisticsCacheKey, Optional<HiveColumnStatistics>>(){

            @Override
            public Optional<HiveColumnStatistics> load(PartitionColumnStatisticsCacheKey key) throws Exception {
                return this.loadAll((Iterable<? extends PartitionColumnStatisticsCacheKey>)ImmutableList.of(key)).get(key);
            }

            @Override
            public Map<PartitionColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> loadAll(Iterable<? extends PartitionColumnStatisticsCacheKey> keys) throws Exception {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, executor));
        this.tableCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<HiveTableName, Optional<Table>>(){

            @Override
            public Optional<Table> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadTable(hiveTableName);
            }
        }, executor));
        this.viewNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<String, Optional<List<String>>>(){

            @Override
            public Optional<List<String>> load(String databaseName) throws Exception {
                return CachingHiveMetastore.this.loadAllViews(databaseName);
            }
        }, executor));
        this.partitionNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<HiveTableName, Optional<List<String>>>(){

            @Override
            public Optional<List<String>> load(HiveTableName hiveTableName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNames(hiveTableName);
            }
        }, executor));
        this.partitionFilterCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<PartitionFilter, Optional<List<String>>>(){

            @Override
            public Optional<List<String>> load(PartitionFilter partitionFilter) throws Exception {
                return CachingHiveMetastore.this.loadPartitionNamesByParts(partitionFilter);
            }
        }, executor));
        this.partitionCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<HivePartitionName, Optional<Partition>>(){

            @Override
            public Optional<Partition> load(HivePartitionName partitionName) throws Exception {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            @Override
            public Map<HivePartitionName, Optional<Partition>> loadAll(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, executor));
        this.userRolesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<String, Set<String>>(){

            @Override
            public Set<String> load(String user) throws Exception {
                return CachingHiveMetastore.this.loadRoles(user);
            }
        }, executor));
        this.userTablePrivileges = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillis, refreshMills, maximumSize).build(CacheLoader.asyncReloading(new CacheLoader<UserTableKey, Set<HivePrivilegeInfo>>(){

            @Override
            public Set<HivePrivilegeInfo> load(UserTableKey key) throws Exception {
                return CachingHiveMetastore.this.loadTablePrivileges(key.getUser(), key.getDatabase(), key.getTable());
            }
        }, executor));
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.userTablePrivileges.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return cache.get(key);
        }
        catch (ExecutionException | ExecutionError | UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (ExecutionException | ExecutionError | UncheckedExecutionException e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) throws Exception {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() throws Exception {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.tableCache, HiveTableName.table(databaseName, tableName));
    }

    private Optional<Table> loadTable(HiveTableName hiveTableName) throws Exception {
        return this.delegate.getTable(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public Optional<Map<String, HiveColumnStatistics>> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        Map<TableColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> cacheValues = CachingHiveMetastore.getAll(this.tableColumnStatisticsCache, columnNames.stream().map(columnName -> new TableColumnStatisticsCacheKey(databaseName, tableName, (String)columnName)).collect(Collectors.toList()));
        return Optional.of(ImmutableMap.copyOf(cacheValues.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(entry -> ((TableColumnStatisticsCacheKey)entry.getKey()).getColumnName(), entry -> (HiveColumnStatistics)((Optional)entry.getValue()).get()))));
    }

    private Map<TableColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> loadColumnStatistics(Iterable<? extends TableColumnStatisticsCacheKey> keys) {
        if (Iterables.isEmpty(keys)) {
            return ImmutableMap.of();
        }
        HiveTableName hiveTableName = Streams.stream(keys).findFirst().get().getHiveTableName();
        Preconditions.checkArgument(Streams.stream(keys).allMatch(key -> key.getHiveTableName().equals(hiveTableName)), "all keys must relate to same hive table");
        Set<String> columnNames = Streams.stream(keys).map(TableColumnStatisticsCacheKey::getColumnName).collect(Collectors.toSet());
        Optional<Map<String, HiveColumnStatistics>> columnStatistics = this.delegate.getTableColumnStatistics(hiveTableName.getDatabaseName(), hiveTableName.getTableName(), columnNames);
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        for (TableColumnStatisticsCacheKey tableColumnStatisticsCacheKey : keys) {
            if (!columnStatistics.isPresent() || !columnStatistics.get().containsKey(tableColumnStatisticsCacheKey.getColumnName())) {
                resultMap.put(tableColumnStatisticsCacheKey, Optional.empty());
                continue;
            }
            resultMap.put(tableColumnStatisticsCacheKey, Optional.of(columnStatistics.get().get(tableColumnStatisticsCacheKey.getColumnName())));
        }
        return resultMap.build();
    }

    @Override
    public Optional<Map<String, Map<String, HiveColumnStatistics>>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        List cacheKeys = partitionNames.stream().flatMap(partitionName -> columnNames.stream().map(columnName -> new PartitionColumnStatisticsCacheKey(databaseName, tableName, (String)partitionName, (String)columnName))).collect(Collectors.toList());
        Map<PartitionColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> cacheValues = CachingHiveMetastore.getAll(this.partitionColumnStatisticsCache, cacheKeys);
        ImmutableMap.Builder partitionsMap = ImmutableMap.builder();
        for (String partitionName2 : partitionNames) {
            ImmutableMap.Builder<String, HiveColumnStatistics> columnsMap = ImmutableMap.builder();
            for (String columnName : columnNames) {
                Optional<HiveColumnStatistics> cacheValue = cacheValues.get(new PartitionColumnStatisticsCacheKey(databaseName, tableName, partitionName2, columnName));
                if (!cacheValue.isPresent()) continue;
                columnsMap.put(columnName, cacheValue.get());
            }
            partitionsMap.put(partitionName2, columnsMap.build());
        }
        return Optional.of(partitionsMap.build());
    }

    private Map<PartitionColumnStatisticsCacheKey, Optional<HiveColumnStatistics>> loadPartitionColumnStatistics(Iterable<? extends PartitionColumnStatisticsCacheKey> keys) {
        if (Iterables.isEmpty(keys)) {
            return ImmutableMap.of();
        }
        PartitionColumnStatisticsCacheKey firstKey = Iterables.getFirst(keys, null);
        HiveTableName hiveTableName = firstKey.getHivePartitionName().getHiveTableName();
        Preconditions.checkArgument(Streams.stream(keys).allMatch(key -> key.getHivePartitionName().getHiveTableName().equals(hiveTableName)), "all keys must relate to same hive table");
        Set<String> partitionNames = Streams.stream(keys).map(key -> key.getHivePartitionName().getPartitionName()).collect(Collectors.toSet());
        Set<String> columnNames = Streams.stream(keys).map(PartitionColumnStatisticsCacheKey::getColumnName).collect(Collectors.toSet());
        Optional<Map<String, Map<String, HiveColumnStatistics>>> columnStatistics = this.delegate.getPartitionColumnStatistics(hiveTableName.getDatabaseName(), hiveTableName.getTableName(), partitionNames, columnNames);
        ImmutableMap.Builder resultMap = ImmutableMap.builder();
        for (PartitionColumnStatisticsCacheKey partitionColumnStatisticsCacheKey : keys) {
            if (columnStatistics.isPresent() && columnStatistics.get().containsKey(partitionColumnStatisticsCacheKey.getHivePartitionName().getPartitionName()) && columnStatistics.get().get(partitionColumnStatisticsCacheKey.getHivePartitionName().getPartitionName()).containsKey(partitionColumnStatisticsCacheKey.getColumnName())) {
                resultMap.put(partitionColumnStatisticsCacheKey, Optional.of(columnStatistics.get().get(partitionColumnStatisticsCacheKey.getHivePartitionName().getPartitionName()).get(partitionColumnStatisticsCacheKey.getColumnName())));
                continue;
            }
            resultMap.put(partitionColumnStatisticsCacheKey, Optional.empty());
        }
        return resultMap.build();
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllTables(String databaseName) throws Exception {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllViews(String databaseName) throws Exception {
        return this.delegate.getAllViews(databaseName);
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.delegate.createDatabase(database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.delegate.dropDatabase(databaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    @Override
    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            this.delegate.renameDatabase(databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate(databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    @Override
    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.createTable(table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.delegate.dropTable(databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        try {
            this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        try {
            this.delegate.renameTable(databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        try {
            this.delegate.addColumn(databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        try {
            this.delegate.renameColumn(databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(String databaseName, String tableName, String columnName) {
        try {
            this.delegate.dropColumn(databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        this.tableCache.invalidate(new HiveTableName(databaseName, tableName));
        this.tableNamesCache.invalidate(databaseName);
        this.viewNamesCache.invalidate(databaseName);
        this.userTablePrivileges.asMap().keySet().stream().filter(userTableKey -> userTableKey.matches(databaseName, tableName)).forEach(this.userTablePrivileges::invalidate);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        HivePartitionName name = HivePartitionName.partition(databaseName, tableName, partitionValues);
        return CachingHiveMetastore.get(this.partitionCache, name);
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.partitionNamesCache, HiveTableName.table(databaseName, tableName));
    }

    private Optional<List<String>> loadPartitionNames(HiveTableName hiveTableName) throws Exception {
        return this.delegate.getPartitionNames(hiveTableName.getDatabaseName(), hiveTableName.getTableName());
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        return CachingHiveMetastore.get(this.partitionFilterCache, PartitionFilter.partitionFilter(databaseName, tableName, parts));
    }

    private Optional<List<String>> loadPartitionNamesByParts(PartitionFilter partitionFilter) throws Exception {
        return this.delegate.getPartitionNamesByParts(partitionFilter.getHiveTableName().getDatabaseName(), partitionFilter.getHiveTableName().getTableName(), partitionFilter.getParts());
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Iterable names = Iterables.transform(partitionNames, name -> HivePartitionName.partition(databaseName, tableName, name));
        Map<HivePartitionName, Optional<Partition>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        ImmutableMap.Builder<String, Optional<Partition>> partitionsByName = ImmutableMap.builder();
        for (Map.Entry<HivePartitionName, Optional<Partition>> entry : all.entrySet()) {
            partitionsByName.put(entry.getKey().getPartitionName(), entry.getValue());
        }
        return partitionsByName.build();
    }

    private Optional<Partition> loadPartitionByName(HivePartitionName partitionName) throws Exception {
        return this.delegate.getPartition(partitionName.getHiveTableName().getDatabaseName(), partitionName.getHiveTableName().getTableName(), partitionName.getPartitionValues());
    }

    private Map<HivePartitionName, Optional<Partition>> loadPartitionsByNames(Iterable<? extends HivePartitionName> partitionNames) throws Exception {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument(!Iterables.isEmpty(partitionNames), "partitionNames is empty");
        HivePartitionName firstPartition = Iterables.get(partitionNames, 0);
        HiveTableName hiveTableName = firstPartition.getHiveTableName();
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (HivePartitionName hivePartitionName : partitionNames) {
            Preconditions.checkArgument(hivePartitionName.getHiveTableName().equals(hiveTableName), "Expected table name %s but got %s", (Object)hiveTableName, (Object)hivePartitionName.getHiveTableName());
            partitionsToFetch.add(hivePartitionName.getPartitionName());
        }
        ImmutableMap.Builder<HivePartitionName, Optional<Partition>> partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(databaseName, tableName, partitionsToFetch);
        for (Map.Entry<String, Optional<Partition>> entry : map.entrySet()) {
            partitions.put(HivePartitionName.partition(hiveTableName, entry.getKey()), entry.getValue());
        }
        return partitions.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(String databaseName, String tableName, List<Partition> partitions) {
        try {
            this.delegate.addPartitions(databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) {
        try {
            this.delegate.alterPartition(databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.table(databaseName, tableName);
        this.partitionNamesCache.invalidate(hiveTableName);
        this.partitionCache.asMap().keySet().stream().filter(partitionName -> partitionName.getHiveTableName().equals(hiveTableName)).forEach(this.partitionCache::invalidate);
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> partitionFilter.getHiveTableName().equals(hiveTableName)).forEach(this.partitionFilterCache::invalidate);
    }

    @Override
    public Set<String> getRoles(String user) {
        return CachingHiveMetastore.get(this.userRolesCache, user);
    }

    private Set<String> loadRoles(String user) throws Exception {
        return this.delegate.getRoles(user);
    }

    @Override
    public Set<HivePrivilegeInfo> getDatabasePrivileges(String user, String databaseName) {
        return this.delegate.getDatabasePrivileges(user, databaseName);
    }

    @Override
    public Set<HivePrivilegeInfo> getTablePrivileges(String user, String databaseName, String tableName) {
        return CachingHiveMetastore.get(this.userTablePrivileges, new UserTableKey(user, tableName, databaseName));
    }

    private Set<HivePrivilegeInfo> loadTablePrivileges(String user, String databaseName, String tableName) {
        return this.delegate.getTablePrivileges(user, databaseName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges);
        }
        finally {
            this.userTablePrivileges.invalidate(new UserTableKey(grantee, tableName, databaseName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        try {
            this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges);
        }
        finally {
            this.userTablePrivileges.invalidate(new UserTableKey(grantee, tableName, databaseName));
        }
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder = cacheBuilder.maximumSize(maximumSize);
        return cacheBuilder;
    }

    private static final class PartitionColumnStatisticsCacheKey {
        private final HivePartitionName hivePartitionName;
        private final String columnName;

        public PartitionColumnStatisticsCacheKey(String databaseName, String tableName, String partitionName, String columnName) {
            this.hivePartitionName = HivePartitionName.partition(Objects.requireNonNull(databaseName, "databaseName is null"), Objects.requireNonNull(tableName, "tableName can not be null"), Objects.requireNonNull(partitionName, "partitionName can not be null"));
            this.columnName = Objects.requireNonNull(columnName, "columnName can not be null");
        }

        public HivePartitionName getHivePartitionName() {
            return this.hivePartitionName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionColumnStatisticsCacheKey that = (PartitionColumnStatisticsCacheKey)o;
            return Objects.equals(this.hivePartitionName, that.hivePartitionName) && Objects.equals(this.columnName, that.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.hivePartitionName, this.columnName);
        }
    }

    private static final class TableColumnStatisticsCacheKey {
        private final HiveTableName hiveTableName;
        private final String columnName;

        public TableColumnStatisticsCacheKey(String databaseName, String tableName, String columnName) {
            this.hiveTableName = HiveTableName.table(Objects.requireNonNull(databaseName, "databaseName is null"), Objects.requireNonNull(tableName, "tableName can not be null"));
            this.columnName = Objects.requireNonNull(columnName, "columnName can not be null");
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableColumnStatisticsCacheKey that = (TableColumnStatisticsCacheKey)o;
            return Objects.equals(this.hiveTableName, that.hiveTableName) && Objects.equals(this.columnName, that.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.hiveTableName, this.columnName);
        }
    }

    private static class UserTableKey {
        private final String user;
        private final String database;
        private final String table;

        public UserTableKey(String user, String table, String database) {
            this.user = Objects.requireNonNull(user, "principalName is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.database = Objects.requireNonNull(database, "database is null");
        }

        public String getUser() {
            return this.user;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }

        public boolean matches(String databaseName, String tableName) {
            return this.database.equals(databaseName) && this.table.equals(tableName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserTableKey that = (UserTableKey)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.table, that.table) && Objects.equals(this.database, that.database);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.table, this.database);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("principalName", this.user).add("table", this.table).add("database", this.database).toString();
        }
    }

    private static class PartitionFilter {
        private final HiveTableName hiveTableName;
        private final List<String> parts;

        private PartitionFilter(HiveTableName hiveTableName, List<String> parts) {
            this.hiveTableName = hiveTableName;
            this.parts = ImmutableList.copyOf(parts);
        }

        public static PartitionFilter partitionFilter(String databaseName, String tableName, List<String> parts) {
            return new PartitionFilter(HiveTableName.table(databaseName, tableName), parts);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("hiveTableName", this.hiveTableName).add("parts", this.parts).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFilter other = (PartitionFilter)o;
            return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.parts, other.parts);
        }

        public int hashCode() {
            return Objects.hash(this.hiveTableName, this.parts);
        }
    }

    private static class HivePartitionName {
        private final HiveTableName hiveTableName;
        private final List<String> partitionValues;
        private final String partitionName;

        private HivePartitionName(HiveTableName hiveTableName, List<String> partitionValues, String partitionName) {
            this.hiveTableName = Objects.requireNonNull(hiveTableName, "hiveTableName is null");
            this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
            this.partitionName = partitionName;
        }

        public static HivePartitionName partition(HiveTableName hiveTableName, String partitionName) {
            return new HivePartitionName(hiveTableName, HiveUtil.toPartitionValues(partitionName), partitionName);
        }

        public static HivePartitionName partition(String databaseName, String tableName, String partitionName) {
            return HivePartitionName.partition(HiveTableName.table(databaseName, tableName), partitionName);
        }

        public static HivePartitionName partition(String databaseName, String tableName, List<String> partitionValues) {
            return new HivePartitionName(HiveTableName.table(databaseName, tableName), partitionValues, null);
        }

        public HiveTableName getHiveTableName() {
            return this.hiveTableName;
        }

        public List<String> getPartitionValues() {
            return this.partitionValues;
        }

        public String getPartitionName() {
            return Objects.requireNonNull(this.partitionName, "partitionName is null");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("hiveTableName", this.hiveTableName).add("partitionValues", this.partitionValues).add("partitionName", this.partitionName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HivePartitionName other = (HivePartitionName)o;
            return Objects.equals(this.hiveTableName, other.hiveTableName) && Objects.equals(this.partitionValues, other.partitionValues);
        }

        public int hashCode() {
            return Objects.hash(this.hiveTableName, this.partitionValues);
        }
    }

    private static class HiveTableName {
        private final String databaseName;
        private final String tableName;

        private HiveTableName(String databaseName, String tableName) {
            this.databaseName = databaseName;
            this.tableName = tableName;
        }

        public static HiveTableName table(String databaseName, String tableName) {
            return new HiveTableName(databaseName, tableName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("databaseName", this.databaseName).add("tableName", this.tableName).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HiveTableName other = (HiveTableName)o;
            return Objects.equals(this.databaseName, other.databaseName) && Objects.equals(this.tableName, other.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.databaseName, this.tableName);
        }
    }
}

