/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication;

import java.util.function.Predicate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.AuthenticationModules;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.AbstractConfigurationAwareModule;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConditionalModule;

public class HiveAuthenticationModule
extends AbstractConfigurationAwareModule {
    @Override
    protected void setup(Binder binder) {
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveClientConfig.HiveMetastoreAuthenticationType.NONE, AuthenticationModules.noHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> config.getHiveMetastoreAuthenticationType() == HiveClientConfig.HiveMetastoreAuthenticationType.KERBEROS, AuthenticationModules.kerberosHiveMetastoreAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.noHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.noHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.simpleImpersonatingHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && !config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosHdfsAuthenticationModule());
        this.bindAuthenticationModule(config -> HiveAuthenticationModule.kerberosHdfsAuth(config) && config.isHdfsImpersonationEnabled(), AuthenticationModules.kerberosImpersonatingHdfsAuthenticationModule());
    }

    private void bindAuthenticationModule(Predicate<HiveClientConfig> predicate, Module module) {
        this.install(ConditionalModule.installModuleIf(HiveClientConfig.class, predicate, module));
    }

    private static boolean noHdfsAuth(HiveClientConfig config) {
        return config.getHdfsAuthenticationType() == HiveClientConfig.HdfsAuthenticationType.NONE;
    }

    private static boolean kerberosHdfsAuth(HiveClientConfig config) {
        return config.getHdfsAuthenticationType() == HiveClientConfig.HdfsAuthenticationType.KERBEROS;
    }
}

