/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication;

import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.KerberosHadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.KerberosTicketUtils;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.security.UserGroupInformationShim;

public class CachingKerberosHadoopAuthentication
implements HadoopAuthentication {
    private final KerberosHadoopAuthentication delegate;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private UserGroupInformation userGroupInformation = null;
    @GuardedBy(value="lock")
    private long nextRefreshTime = Long.MIN_VALUE;

    public CachingKerberosHadoopAuthentication(KerberosHadoopAuthentication delegate) {
        this.delegate = Objects.requireNonNull(delegate, "hadoopAuthentication is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserGroupInformation getUserGroupInformation() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refreshIsNeeded()) {
                this.refreshUgi();
            }
        }
        return this.userGroupInformation;
    }

    private void refreshUgi() {
        this.userGroupInformation = this.delegate.getUserGroupInformation();
        this.nextRefreshTime = this.calculateNextRefreshTime(this.userGroupInformation);
    }

    private boolean refreshIsNeeded() {
        return this.nextRefreshTime < System.currentTimeMillis() || this.userGroupInformation == null;
    }

    private long calculateNextRefreshTime(UserGroupInformation userGroupInformation) {
        Subject subject = UserGroupInformationShim.getSubject(userGroupInformation);
        Preconditions.checkArgument(subject != null, "subject must be present in kerberos based UGI");
        KerberosTicket tgtTicket = KerberosTicketUtils.getTicketGrantingTicket(subject);
        return KerberosTicketUtils.getRefreshTime(tgtTicket);
    }
}

