/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.SchemaTableName;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Strings;

public class TableOfflineException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableOfflineException(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_OFFLINE, TableOfflineException.formatMessage(tableName, forPresto, offlineMessage));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    private static String formatMessage(SchemaTableName tableName, boolean forPresto, String offlineMessage) {
        StringBuilder resultBuilder = new StringBuilder().append("Table '").append(tableName).append("'").append(" is offline");
        if (forPresto) {
            resultBuilder.append(" for Presto");
        }
        if (!Strings.isNullOrEmpty(offlineMessage)) {
            resultBuilder.append(": ").append(offlineMessage);
        }
        return resultBuilder.toString();
    }
}

