/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.FileFormatDataSourceStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSessionProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.NodeVersion;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.RcFileFileWriter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.StorageFormat;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.rcfile.HdfsRcFileDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileEncoding;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Splitter;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapred.JobConf;
import org.apache.flink.fs.s3presto.shaded.org.joda.time.DateTimeZone;

public class RcFileFileWriterFactory
implements HiveFileWriterFactory {
    private final DateTimeZone hiveStorageTimeZone;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final NodeVersion nodeVersion;
    private final FileFormatDataSourceStats stats;

    @Inject
    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, HiveClientConfig hiveClientConfig, FileFormatDataSourceStats stats) {
        this(hdfsEnvironment, typeManager, nodeVersion, Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null").getDateTimeZone(), stats);
    }

    public RcFileFileWriterFactory(HdfsEnvironment hdfsEnvironment, TypeManager typeManager, NodeVersion nodeVersion, DateTimeZone hiveStorageTimeZone, FileFormatDataSourceStats stats) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.hiveStorageTimeZone = Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<HiveFileWriter> createFileWriter(Path path, List<String> inputColumnNames, StorageFormat storageFormat, Properties schema, JobConf configuration, ConnectorSession session) {
        BinaryRcFileEncoding rcFileEncoding;
        if (!HiveSessionProperties.isRcfileOptimizedWriterEnabled(session)) {
            return Optional.empty();
        }
        if (!RCFileOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return Optional.empty();
        }
        if (LazyBinaryColumnarSerDe.class.getName().equals(storageFormat.getSerDe())) {
            rcFileEncoding = new BinaryRcFileEncoding();
        } else if (ColumnarSerDe.class.getName().equals(storageFormat.getSerDe())) {
            rcFileEncoding = RcFilePageSourceFactory.createTextVectorEncoding(schema, this.hiveStorageTimeZone);
        } else {
            return Optional.empty();
        }
        Optional<String> codecName = Optional.ofNullable(configuration.get("mapreduce.output.fileoutputformat.compress.codec"));
        List<String> fileColumnNames = Splitter.on(',').trimResults().omitEmptyStrings().splitToList(schema.getProperty("columns", ""));
        List<Type> fileColumnTypes = HiveType.toHiveTypes(schema.getProperty("columns.types", "")).stream().map(hiveType -> hiveType.getType(this.typeManager)).collect(Collectors.toList());
        int[] fileInputColumnIndexes = fileColumnNames.stream().mapToInt(inputColumnNames::indexOf).toArray();
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
            FSDataOutputStream outputStream = fileSystem.create(path);
            Optional<Supplier<RcFileDataSource>> validationInputFactory = Optional.empty();
            if (HiveSessionProperties.isRcfileOptimizedWriterValidate(session)) {
                validationInputFactory = Optional.of(() -> {
                    try {
                        return new HdfsRcFileDataSource(path.toString(), fileSystem.open(path), fileSystem.getFileStatus(path).getLen(), this.stats);
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
                    }
                });
            }
            Callable<Void> rollbackAction = () -> {
                fileSystem.delete(path, false);
                return null;
            };
            return Optional.of(new RcFileFileWriter(outputStream, rollbackAction, (RcFileEncoding)rcFileEncoding, fileColumnTypes, codecName, fileInputColumnIndexes, ImmutableMap.builder().put("presto_version", this.nodeVersion.toString()).put("presto_query_id", session.getQueryId()).build(), validationInputFactory));
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating RCFile file", (Throwable)e);
        }
    }
}

