/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.AircompressorCodecFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.HadoopCodecFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileCodecFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileEncoding;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileWriter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Page;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilderStatus;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.RunLengthEncodedBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.OutputStreamSliceOutput;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.SliceOutput;

public class RcFileFileWriter
implements HiveFileWriter {
    private final RcFileWriter rcFileWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<RcFileDataSource>> validationInputFactory;

    public RcFileFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, RcFileEncoding rcFileEncoding, List<Type> fileColumnTypes, Optional<String> codecName, int[] fileInputColumnIndexes, Map<String, String> metadata, Optional<Supplier<RcFileDataSource>> validationInputFactory) throws IOException {
        this.rcFileWriter = new RcFileWriter(outputStream instanceof SliceOutput ? (SliceOutput)outputStream : new OutputStreamSliceOutput(outputStream), fileColumnTypes, rcFileEncoding, codecName, (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(this.getClass().getClassLoader())), metadata, validationInputFactory.isPresent());
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "outputColumnInputIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(new BlockBuilderStatus(), 1, 0);
            blockBuilder.appendNull();
            nullBlocks.add(blockBuilder.build());
        }
        this.nullBlocks = nullBlocks.build();
        this.validationInputFactory = validationInputFactory;
    }

    @Override
    public long getSystemMemoryUsage() {
        return this.rcFileWriter.getRetainedSizeInBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? new RunLengthEncodedBlock(this.nullBlocks.get(i), dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.rcFileWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commit() {
        try {
            this.rcFileWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (RcFileDataSource input = this.validationInputFactory.get().get();){
                this.rcFileWriter.validate(input);
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.rcFileWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("writer", this.rcFileWriter).toString();
    }
}

