/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AbortedException;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.Protocol;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSStaticCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.BasicAWSCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.event.ProgressEvent;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.event.ProgressEventType;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.event.ProgressListener;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.regions.Region;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.regions.Regions;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.AmazonS3Client;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.AmazonS3EncryptionClient;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.AmazonS3Exception;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.ObjectListing;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.S3ObjectInputStream;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.transfer.Transfer;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.transfer.TransferManager;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.transfer.TransferManagerConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.transfer.Upload;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.HadoopFileStatus;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveS3Config;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystemMetricCollector;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystemStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3SseType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.RetryDriver;
import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Strings;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.AbstractSequentialIterator;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Iterables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Iterators;
import org.apache.flink.fs.s3presto.shaded.io.airlift.log.Logger;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configurable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FSInputStream;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.util.Progressable;

public class PrestoS3FileSystem
extends FileSystem {
    private static final Logger log = Logger.get(PrestoS3FileSystem.class);
    private static final PrestoS3FileSystemStats STATS = new PrestoS3FileSystemStats();
    private static final PrestoS3FileSystemMetricCollector METRIC_COLLECTOR = new PrestoS3FileSystemMetricCollector(STATS);
    private static final String DIRECTORY_SUFFIX = "_$folder$";
    public static final String S3_ACCESS_KEY = "presto.s3.access-key";
    public static final String S3_SECRET_KEY = "presto.s3.secret-key";
    public static final String S3_ENDPOINT = "presto.s3.endpoint";
    public static final String S3_SIGNER_TYPE = "presto.s3.signer-type";
    public static final String S3_SSL_ENABLED = "presto.s3.ssl.enabled";
    public static final String S3_MAX_ERROR_RETRIES = "presto.s3.max-error-retries";
    public static final String S3_MAX_CLIENT_RETRIES = "presto.s3.max-client-retries";
    public static final String S3_MAX_BACKOFF_TIME = "presto.s3.max-backoff-time";
    public static final String S3_MAX_RETRY_TIME = "presto.s3.max-retry-time";
    public static final String S3_CONNECT_TIMEOUT = "presto.s3.connect-timeout";
    public static final String S3_SOCKET_TIMEOUT = "presto.s3.socket-timeout";
    public static final String S3_MAX_CONNECTIONS = "presto.s3.max-connections";
    public static final String S3_STAGING_DIRECTORY = "presto.s3.staging-directory";
    public static final String S3_MULTIPART_MIN_FILE_SIZE = "presto.s3.multipart.min-file-size";
    public static final String S3_MULTIPART_MIN_PART_SIZE = "presto.s3.multipart.min-part-size";
    public static final String S3_USE_INSTANCE_CREDENTIALS = "presto.s3.use-instance-credentials";
    public static final String S3_PIN_CLIENT_TO_CURRENT_REGION = "presto.s3.pin-client-to-current-region";
    public static final String S3_ENCRYPTION_MATERIALS_PROVIDER = "presto.s3.encryption-materials-provider";
    public static final String S3_KMS_KEY_ID = "presto.s3.kms-key-id";
    public static final String S3_SSE_KMS_KEY_ID = "presto.s3.sse.kms-key-id";
    public static final String S3_SSE_ENABLED = "presto.s3.sse.enabled";
    public static final String S3_SSE_TYPE = "presto.s3.sse.type";
    public static final String S3_CREDENTIALS_PROVIDER = "presto.s3.credentials-provider";
    public static final String S3_USER_AGENT_PREFIX = "presto.s3.user-agent-prefix";
    public static final String S3_USER_AGENT_SUFFIX = "presto";
    private static final DataSize BLOCK_SIZE = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_SKIP_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final String PATH_SEPARATOR = "/";
    private static final Duration BACKOFF_MIN_SLEEP = new Duration(1.0, TimeUnit.SECONDS);
    private final TransferManagerConfiguration transferConfig = new TransferManagerConfiguration();
    private URI uri;
    private Path workingDirectory;
    private AmazonS3 s3;
    private File stagingDirectory;
    private int maxAttempts;
    private Duration maxBackoffTime;
    private Duration maxRetryTime;
    private boolean useInstanceCredentials;
    private boolean pinS3ClientToCurrentRegion;
    private boolean sseEnabled;
    private PrestoS3SseType sseType;
    private String sseKmsKeyId;

    public static PrestoS3FileSystemStats getFileSystemStats() {
        return STATS;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        Objects.requireNonNull(uri, "uri is null");
        Objects.requireNonNull(conf, "conf is null");
        super.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDirectory = new Path(PATH_SEPARATOR).makeQualified(this.uri, new Path(PATH_SEPARATOR));
        HiveS3Config defaults = new HiveS3Config();
        this.stagingDirectory = new File(conf.get(S3_STAGING_DIRECTORY, defaults.getS3StagingDirectory().toString()));
        this.maxAttempts = conf.getInt(S3_MAX_CLIENT_RETRIES, defaults.getS3MaxClientRetries()) + 1;
        this.maxBackoffTime = Duration.valueOf(conf.get(S3_MAX_BACKOFF_TIME, defaults.getS3MaxBackoffTime().toString()));
        this.maxRetryTime = Duration.valueOf(conf.get(S3_MAX_RETRY_TIME, defaults.getS3MaxRetryTime().toString()));
        int maxErrorRetries = conf.getInt(S3_MAX_ERROR_RETRIES, defaults.getS3MaxErrorRetries());
        boolean sslEnabled = conf.getBoolean(S3_SSL_ENABLED, defaults.isS3SslEnabled());
        Duration connectTimeout = Duration.valueOf(conf.get(S3_CONNECT_TIMEOUT, defaults.getS3ConnectTimeout().toString()));
        Duration socketTimeout = Duration.valueOf(conf.get(S3_SOCKET_TIMEOUT, defaults.getS3SocketTimeout().toString()));
        int maxConnections = conf.getInt(S3_MAX_CONNECTIONS, defaults.getS3MaxConnections());
        long minFileSize = conf.getLong(S3_MULTIPART_MIN_FILE_SIZE, defaults.getS3MultipartMinFileSize().toBytes());
        long minPartSize = conf.getLong(S3_MULTIPART_MIN_PART_SIZE, defaults.getS3MultipartMinPartSize().toBytes());
        this.useInstanceCredentials = conf.getBoolean(S3_USE_INSTANCE_CREDENTIALS, defaults.isS3UseInstanceCredentials());
        this.pinS3ClientToCurrentRegion = conf.getBoolean(S3_PIN_CLIENT_TO_CURRENT_REGION, defaults.isPinS3ClientToCurrentRegion());
        this.sseEnabled = conf.getBoolean(S3_SSE_ENABLED, defaults.isS3SseEnabled());
        this.sseType = PrestoS3SseType.valueOf(conf.get(S3_SSE_TYPE, defaults.getS3SseType().name()));
        this.sseKmsKeyId = conf.get(S3_SSE_KMS_KEY_ID, defaults.getS3SseKmsKeyId());
        String userAgentPrefix = conf.get(S3_USER_AGENT_PREFIX, defaults.getS3UserAgentPrefix());
        ClientConfiguration configuration = new ClientConfiguration().withMaxErrorRetry(maxErrorRetries).withProtocol(sslEnabled ? Protocol.HTTPS : Protocol.HTTP).withConnectionTimeout(Math.toIntExact(connectTimeout.toMillis())).withSocketTimeout(Math.toIntExact(socketTimeout.toMillis())).withMaxConnections(maxConnections).withUserAgentPrefix(userAgentPrefix).withUserAgentSuffix(S3_USER_AGENT_SUFFIX);
        this.s3 = this.createAmazonS3Client(uri, conf, configuration);
        this.transferConfig.setMultipartUploadThreshold(minFileSize);
        this.transferConfig.setMinimumUploadPartSize(minPartSize);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.s3.shutdown();
        }
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setWorkingDirectory(Path path) {
        this.workingDirectory = path;
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        STATS.newListStatusCall();
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>();
        RemoteIterator<LocatedFileStatus> iterator = this.listLocatedStatus(path);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return Iterables.toArray(list, LocatedFileStatus.class);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path path) {
        STATS.newListLocatedStatusCall();
        return new RemoteIterator<LocatedFileStatus>(){
            private final Iterator<LocatedFileStatus> iterator;
            {
                this.iterator = PrestoS3FileSystem.this.listPrefix(path);
            }

            @Override
            public boolean hasNext() throws IOException {
                try {
                    return this.iterator.hasNext();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public LocatedFileStatus next() throws IOException {
                try {
                    return this.iterator.next();
                }
                catch (AmazonClientException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        if (path.getName().isEmpty()) {
            if (this.getS3ObjectMetadata(path) != null) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        ObjectMetadata metadata = this.getS3ObjectMetadata(path);
        if (metadata == null) {
            Iterator<LocatedFileStatus> iterator = this.listPrefix(path);
            if (iterator.hasNext()) {
                return new FileStatus(0L, true, 1, 0L, 0L, this.qualifiedPath(path));
            }
            throw new FileNotFoundException("File does not exist: " + path);
        }
        return new FileStatus(PrestoS3FileSystem.getObjectSize(path, metadata), false, 1, BLOCK_SIZE.toBytes(), PrestoS3FileSystem.lastModifiedTime(metadata), this.qualifiedPath(path));
    }

    private static long getObjectSize(Path path, ObjectMetadata metadata) throws IOException {
        Map<String, String> userMetadata = metadata.getUserMetadata();
        String length = userMetadata.get("x-amz-unencrypted-content-length");
        if (userMetadata.containsKey("x-amz-server-side-encryption") && length == null) {
            throw new IOException(String.format("%s header is not set on an encrypted object: %s", "x-amz-unencrypted-content-length", path));
        }
        return length != null ? Long.parseLong(length) : metadata.getContentLength();
    }

    @Override
    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        return new FSDataInputStream(new BufferedFSInputStream(new PrestoS3InputStream(this.s3, this.uri.getHost(), path, this.maxAttempts, this.maxBackoffTime, this.maxRetryTime), bufferSize));
    }

    @Override
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (!overwrite && this.exists(path)) {
            throw new IOException("File already exists:" + path);
        }
        if (!this.stagingDirectory.exists()) {
            Files.createDirectories(this.stagingDirectory.toPath(), new FileAttribute[0]);
        }
        if (!this.stagingDirectory.isDirectory()) {
            throw new IOException("Configured staging path is not a directory: " + this.stagingDirectory);
        }
        File tempFile = Files.createTempFile(this.stagingDirectory.toPath(), "presto-s3-", ".tmp", new FileAttribute[0]).toFile();
        String key = PrestoS3FileSystem.keyFromPath(this.qualifiedPath(path));
        return new FSDataOutputStream(new PrestoS3OutputStream(this.s3, this.transferConfig, this.uri.getHost(), key, tempFile, this.sseEnabled, this.sseType, this.sseKmsKeyId), this.statistics);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("append");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcDirectory;
        try {
            srcDirectory = this.directory(src);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            if (!this.directory(dst)) {
                return PrestoS3FileSystem.keysEqual(src, dst);
            }
            dst = new Path(dst, src.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (PrestoS3FileSystem.keysEqual(src, dst)) {
            return true;
        }
        if (srcDirectory) {
            for (FileStatus file : this.listStatus(src)) {
                this.rename(file.getPath(), new Path(dst, file.getPath().getName()));
            }
            this.deleteObject(PrestoS3FileSystem.keyFromPath(src) + DIRECTORY_SUFFIX);
        } else {
            this.s3.copyObject(this.uri.getHost(), PrestoS3FileSystem.keyFromPath(src), this.uri.getHost(), PrestoS3FileSystem.keyFromPath(dst));
            this.delete(src, true);
        }
        return true;
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        try {
            if (!this.directory(path)) {
                return this.deleteObject(PrestoS3FileSystem.keyFromPath(path));
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (!recursive) {
            throw new IOException("Directory " + path + " is not empty");
        }
        for (FileStatus file : this.listStatus(path)) {
            this.delete(file.getPath(), true);
        }
        this.deleteObject(PrestoS3FileSystem.keyFromPath(path) + DIRECTORY_SUFFIX);
        return true;
    }

    private boolean directory(Path path) throws IOException {
        return HadoopFileStatus.isDirectory(this.getFileStatus(path));
    }

    private boolean deleteObject(String key) {
        try {
            this.s3.deleteObject(this.uri.getHost(), key);
            return true;
        }
        catch (AmazonClientException e) {
            return false;
        }
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) {
        return true;
    }

    private Iterator<LocatedFileStatus> listPrefix(Path path) {
        String key = PrestoS3FileSystem.keyFromPath(path);
        if (!key.isEmpty()) {
            key = key + PATH_SEPARATOR;
        }
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.uri.getHost()).withPrefix(key).withDelimiter(PATH_SEPARATOR);
        STATS.newListObjectsCall();
        AbstractSequentialIterator<ObjectListing> listings = new AbstractSequentialIterator<ObjectListing>(this.s3.listObjects(request)){

            @Override
            protected ObjectListing computeNext(ObjectListing previous) {
                if (!previous.isTruncated()) {
                    return null;
                }
                return PrestoS3FileSystem.this.s3.listNextBatchOfObjects(previous);
            }
        };
        return Iterators.concat(Iterators.transform(listings, this::statusFromListing));
    }

    private Iterator<LocatedFileStatus> statusFromListing(ObjectListing listing) {
        return Iterators.concat(this.statusFromPrefixes(listing.getCommonPrefixes()), this.statusFromObjects(listing.getObjectSummaries()));
    }

    private Iterator<LocatedFileStatus> statusFromPrefixes(List<String> prefixes) {
        ArrayList<LocatedFileStatus> list = new ArrayList<LocatedFileStatus>();
        for (String prefix : prefixes) {
            Path path = this.qualifiedPath(new Path(PATH_SEPARATOR + prefix));
            FileStatus status = new FileStatus(0L, true, 1, 0L, 0L, path);
            list.add(this.createLocatedFileStatus(status));
        }
        return list.iterator();
    }

    private Iterator<LocatedFileStatus> statusFromObjects(List<S3ObjectSummary> objects) {
        return objects.stream().filter(object -> !object.getKey().endsWith(PATH_SEPARATOR)).map(object -> new FileStatus(object.getSize(), false, 1, BLOCK_SIZE.toBytes(), object.getLastModified().getTime(), this.qualifiedPath(new Path(PATH_SEPARATOR + object.getKey())))).map(this::createLocatedFileStatus).iterator();
    }

    @VisibleForTesting
    ObjectMetadata getS3ObjectMetadata(Path path) throws IOException {
        try {
            return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetMetadataRetry).run("getS3ObjectMetadata", () -> {
                try {
                    STATS.newMetadataCall();
                    return this.s3.getObjectMetadata(this.uri.getHost(), PrestoS3FileSystem.keyFromPath(path));
                }
                catch (RuntimeException e) {
                    STATS.newGetMetadataError();
                    if (e instanceof AmazonS3Exception) {
                        switch (((AmazonS3Exception)e).getStatusCode()) {
                            case 404: {
                                return null;
                            }
                            case 400: 
                            case 403: {
                                throw new UnrecoverableS3OperationException(path, (Throwable)e);
                            }
                        }
                    }
                    throw Throwables.propagate(e);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate(e);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf(e, IOException.class);
            throw Throwables.propagate(e);
        }
    }

    private Path qualifiedPath(Path path) {
        return path.makeQualified(this.uri, this.getWorkingDirectory());
    }

    private LocatedFileStatus createLocatedFileStatus(FileStatus status) {
        try {
            BlockLocation[] fakeLocation = this.getFileBlockLocations(status, 0L, status.getLen());
            return new LocatedFileStatus(status, fakeLocation);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private static long lastModifiedTime(ObjectMetadata metadata) {
        Date date = metadata.getLastModified();
        return date != null ? date.getTime() : 0L;
    }

    private static boolean keysEqual(Path p1, Path p2) {
        return PrestoS3FileSystem.keyFromPath(p1).equals(PrestoS3FileSystem.keyFromPath(p2));
    }

    private static String keyFromPath(Path path) {
        Preconditions.checkArgument(path.isAbsolute(), "Path is not absolute: %s", (Object)path);
        String key = Strings.nullToEmpty(path.toUri().getPath());
        if (key.startsWith(PATH_SEPARATOR)) {
            key = key.substring(PATH_SEPARATOR.length());
        }
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key;
    }

    private AmazonS3Client createAmazonS3Client(URI uri, Configuration hadoopConfig, ClientConfiguration clientConfig) {
        String endpoint;
        Region region;
        AWSCredentialsProvider credentials = this.getAwsCredentialsProvider(uri, hadoopConfig);
        Optional<EncryptionMaterialsProvider> emp = PrestoS3FileSystem.createEncryptionMaterialsProvider(hadoopConfig);
        String signerType = hadoopConfig.get(S3_SIGNER_TYPE);
        if (signerType != null) {
            clientConfig.withSignerOverride(signerType);
        }
        AmazonS3Client client = emp.isPresent() ? new AmazonS3EncryptionClient(credentials, emp.get(), clientConfig, new CryptoConfiguration(), METRIC_COLLECTOR) : new AmazonS3Client(credentials, clientConfig, METRIC_COLLECTOR);
        if (this.pinS3ClientToCurrentRegion && (region = Regions.getCurrentRegion()) != null) {
            client.setRegion(region);
        }
        if ((endpoint = hadoopConfig.get(S3_ENDPOINT)) != null) {
            client.setEndpoint(endpoint);
        }
        return client;
    }

    private static Optional<EncryptionMaterialsProvider> createEncryptionMaterialsProvider(Configuration hadoopConfig) {
        String kmsKeyId = hadoopConfig.get(S3_KMS_KEY_ID);
        if (kmsKeyId != null) {
            return Optional.of(new KMSEncryptionMaterialsProvider(kmsKeyId));
        }
        String empClassName = hadoopConfig.get(S3_ENCRYPTION_MATERIALS_PROVIDER);
        if (empClassName == null) {
            return Optional.empty();
        }
        try {
            Object instance = Class.forName(empClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(instance instanceof EncryptionMaterialsProvider)) {
                throw new RuntimeException("Invalid encryption materials provider class: " + instance.getClass().getName());
            }
            EncryptionMaterialsProvider emp = (EncryptionMaterialsProvider)instance;
            if (emp instanceof Configurable) {
                ((Configurable)((Object)emp)).setConf(hadoopConfig);
            }
            return Optional.of(emp);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load or create S3 encryption materials provider: " + empClassName, e);
        }
    }

    private AWSCredentialsProvider getAwsCredentialsProvider(URI uri, Configuration conf) {
        Optional<AWSCredentials> credentials = PrestoS3FileSystem.getAwsCredentials(uri, conf);
        if (credentials.isPresent()) {
            return new AWSStaticCredentialsProvider(credentials.get());
        }
        if (this.useInstanceCredentials) {
            return new InstanceProfileCredentialsProvider();
        }
        String providerClass = conf.get(S3_CREDENTIALS_PROVIDER);
        if (!Strings.isNullOrEmpty(providerClass)) {
            return PrestoS3FileSystem.getCustomAWSCredentialsProvider(uri, conf, providerClass);
        }
        throw new RuntimeException("S3 credentials not configured");
    }

    private static AWSCredentialsProvider getCustomAWSCredentialsProvider(URI uri, Configuration conf, String providerClass) {
        try {
            log.debug("Using AWS credential provider %s for URI %s", providerClass, uri);
            return conf.getClassByName(providerClass).asSubclass(AWSCredentialsProvider.class).getConstructor(URI.class, Configuration.class).newInstance(uri, conf);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Error creating an instance of %s for URI %s", providerClass, uri), e);
        }
    }

    private static Optional<AWSCredentials> getAwsCredentials(URI uri, Configuration conf) {
        String accessKey = conf.get(S3_ACCESS_KEY);
        String secretKey = conf.get(S3_SECRET_KEY);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            if (index < 0) {
                accessKey = userInfo;
            } else {
                accessKey = userInfo.substring(0, index);
                secretKey = userInfo.substring(index + 1);
            }
        }
        if (Strings.isNullOrEmpty(accessKey) || Strings.isNullOrEmpty(secretKey)) {
            return Optional.empty();
        }
        return Optional.of(new BasicAWSCredentials(accessKey, secretKey));
    }

    @VisibleForTesting
    AmazonS3 getS3Client() {
        return this.s3;
    }

    @VisibleForTesting
    void setS3Client(AmazonS3 client) {
        this.s3 = client;
    }

    private static class PrestoS3OutputStream
    extends FilterOutputStream {
        private final TransferManager transferManager;
        private final String host;
        private final String key;
        private final File tempFile;
        private final boolean sseEnabled;
        private final PrestoS3SseType sseType;
        private final String sseKmsKeyId;
        private boolean closed;

        public PrestoS3OutputStream(AmazonS3 s3, TransferManagerConfiguration config, String host, String key, File tempFile, boolean sseEnabled, PrestoS3SseType sseType, String sseKmsKeyId) throws IOException {
            super(new BufferedOutputStream(new FileOutputStream(Objects.requireNonNull(tempFile, "tempFile is null"))));
            this.transferManager = new TransferManager(Objects.requireNonNull(s3, "s3 is null"));
            this.transferManager.setConfiguration(Objects.requireNonNull(config, "config is null"));
            this.host = Objects.requireNonNull(host, "host is null");
            this.key = Objects.requireNonNull(key, "key is null");
            this.tempFile = tempFile;
            this.sseEnabled = sseEnabled;
            this.sseType = Objects.requireNonNull(sseType, "sseType is null");
            this.sseKmsKeyId = sseKmsKeyId;
            log.debug("OutputStream for key '%s' using file: %s", key, tempFile);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            block4: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                    this.uploadObject();
                    if (this.tempFile.delete()) break block4;
                }
                catch (Throwable throwable) {
                    if (!this.tempFile.delete()) {
                        log.warn("Could not delete temporary file: %s", this.tempFile);
                    }
                    this.transferManager.shutdownNow(false);
                    throw throwable;
                }
                log.warn("Could not delete temporary file: %s", this.tempFile);
            }
            this.transferManager.shutdownNow(false);
        }

        private void uploadObject() throws IOException {
            try {
                log.debug("Starting upload for host: %s, key: %s, file: %s, size: %s", this.host, this.key, this.tempFile, this.tempFile.length());
                STATS.uploadStarted();
                PutObjectRequest request = new PutObjectRequest(this.host, this.key, this.tempFile);
                if (this.sseEnabled) {
                    switch (this.sseType) {
                        case KMS: {
                            if (this.sseKmsKeyId != null) {
                                request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseKmsKeyId));
                                break;
                            }
                            request.withSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams());
                            break;
                        }
                        case S3: {
                            ObjectMetadata metadata = new ObjectMetadata();
                            metadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                            request.setMetadata(metadata);
                        }
                    }
                }
                Upload upload = this.transferManager.upload(request);
                if (log.isDebugEnabled()) {
                    upload.addProgressListener(this.createProgressListener(upload));
                }
                upload.waitForCompletion();
                STATS.uploadSuccessful();
                log.debug("Completed upload for host: %s, key: %s", this.host, this.key);
            }
            catch (AmazonClientException e) {
                STATS.uploadFailed();
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                STATS.uploadFailed();
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }

        private ProgressListener createProgressListener(final Transfer transfer) {
            return new ProgressListener(){
                private ProgressEventType previousType;
                private double previousTransferred;

                @Override
                public synchronized void progressChanged(ProgressEvent progressEvent) {
                    double transferred;
                    ProgressEventType eventType = progressEvent.getEventType();
                    if (this.previousType != eventType) {
                        log.debug("Upload progress event (%s/%s): %s", new Object[]{host, key, eventType});
                        this.previousType = eventType;
                    }
                    if ((transferred = transfer.getProgress().getPercentTransferred()) >= this.previousTransferred + 10.0) {
                        log.debug("Upload percentage (%s/%s): %.0f%%", host, key, transferred);
                        this.previousTransferred = transferred;
                    }
                }
            };
        }
    }

    private static class PrestoS3InputStream
    extends FSInputStream {
        private final AmazonS3 s3;
        private final String host;
        private final Path path;
        private final int maxAttempts;
        private final Duration maxBackoffTime;
        private final Duration maxRetryTime;
        private boolean closed;
        private InputStream in;
        private long streamPosition;
        private long nextReadPosition;

        public PrestoS3InputStream(AmazonS3 s3, String host, Path path, int maxAttempts, Duration maxBackoffTime, Duration maxRetryTime) {
            this.s3 = Objects.requireNonNull(s3, "s3 is null");
            this.host = Objects.requireNonNull(host, "host is null");
            this.path = Objects.requireNonNull(path, "path is null");
            Preconditions.checkArgument(maxAttempts >= 0, "maxAttempts cannot be negative");
            this.maxAttempts = maxAttempts;
            this.maxBackoffTime = Objects.requireNonNull(maxBackoffTime, "maxBackoffTime is null");
            this.maxRetryTime = Objects.requireNonNull(maxRetryTime, "maxRetryTime is null");
        }

        @Override
        public void close() {
            this.closed = true;
            this.closeStream();
        }

        @Override
        public void seek(long pos) {
            Preconditions.checkState(!this.closed, "already closed");
            Preconditions.checkArgument(pos >= 0L, "position is negative: %s", pos);
            this.nextReadPosition = pos;
        }

        @Override
        public long getPos() {
            return this.nextReadPosition;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                int bytesRead = RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class, AbortedException.class).onRetry(STATS::newReadRetry).run("readStream", () -> {
                    this.seekStream();
                    try {
                        return this.in.read(buffer, offset, length);
                    }
                    catch (Exception e) {
                        STATS.newReadError(e);
                        this.closeStream();
                        throw e;
                    }
                });
                if (bytesRead != -1) {
                    this.streamPosition += (long)bytesRead;
                    this.nextReadPosition += (long)bytesRead;
                }
                return bytesRead;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate(e);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf(e, IOException.class);
                throw Throwables.propagate(e);
            }
        }

        @Override
        public boolean seekToNewSource(long targetPos) {
            return false;
        }

        private void seekStream() throws IOException {
            long skip;
            if (this.in != null && this.nextReadPosition == this.streamPosition) {
                return;
            }
            if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= Math.max((long)this.in.available(), MAX_SKIP_SIZE.toBytes())) {
                try {
                    if (this.in.skip(skip) == skip) {
                        this.streamPosition = this.nextReadPosition;
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.streamPosition = this.nextReadPosition;
            this.closeStream();
            this.openStream();
        }

        private void openStream() throws IOException {
            if (this.in == null) {
                this.in = this.openStream(this.path, this.nextReadPosition);
                this.streamPosition = this.nextReadPosition;
                STATS.connectionOpened();
            }
        }

        private InputStream openStream(Path path, long start) throws IOException {
            try {
                return RetryDriver.retry().maxAttempts(this.maxAttempts).exponentialBackoff(BACKOFF_MIN_SLEEP, this.maxBackoffTime, this.maxRetryTime, 2.0).stopOn(InterruptedException.class, UnrecoverableS3OperationException.class).onRetry(STATS::newGetObjectRetry).run("getS3Object", () -> {
                    try {
                        GetObjectRequest request = new GetObjectRequest(this.host, PrestoS3FileSystem.keyFromPath(path)).withRange(start, Long.MAX_VALUE);
                        return this.s3.getObject(request).getObjectContent();
                    }
                    catch (RuntimeException e) {
                        STATS.newGetObjectError();
                        if (e instanceof AmazonS3Exception) {
                            switch (((AmazonS3Exception)e).getStatusCode()) {
                                case 416: {
                                    return new ByteArrayInputStream(new byte[0]);
                                }
                                case 400: 
                                case 403: 
                                case 404: {
                                    throw new UnrecoverableS3OperationException(path, (Throwable)e);
                                }
                            }
                        }
                        throw Throwables.propagate(e);
                    }
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate(e);
            }
            catch (Exception e) {
                Throwables.throwIfInstanceOf(e, IOException.class);
                throw Throwables.propagate(e);
            }
        }

        private void closeStream() {
            if (this.in != null) {
                try {
                    if (this.in instanceof S3ObjectInputStream) {
                        ((S3ObjectInputStream)this.in).abort();
                    } else {
                        this.in.close();
                    }
                }
                catch (IOException | AbortedException exception) {
                    // empty catch block
                }
                this.in = null;
                STATS.connectionReleased();
            }
        }
    }

    @VisibleForTesting
    static class UnrecoverableS3OperationException
    extends RuntimeException {
        public UnrecoverableS3OperationException(Path path, Throwable cause) {
            super(String.format("%s (Path: %s)", cause, path), cause);
        }
    }
}

