/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.SchemaTableName;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Strings;

public class PartitionOfflineException
extends PrestoException {
    private final SchemaTableName tableName;
    private final String partition;

    public PartitionOfflineException(SchemaTableName tableName, String partitionName, boolean forPresto, String offlineMessage) {
        super((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_OFFLINE, PartitionOfflineException.formatMessage(tableName, partitionName, forPresto, offlineMessage));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partition = Objects.requireNonNull(partitionName, "partition is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getPartition() {
        return this.partition;
    }

    private static String formatMessage(SchemaTableName tableName, String partitionName, boolean forPresto, String offlineMessage) {
        StringBuilder resultBuilder = new StringBuilder().append("Table '").append(tableName).append("'").append(" partition '").append(partitionName).append("'").append(" is offline");
        if (forPresto) {
            resultBuilder.append(" for Presto");
        }
        if (!Strings.isNullOrEmpty(offlineMessage)) {
            resultBuilder.append(": ").append(offlineMessage);
        }
        return resultBuilder.toString();
    }
}

