/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Collection;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveInsertTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveOutputTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSink;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSessionProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveWritableTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.LocationService;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PartitionUpdate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HivePageSinkMetadataProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorInsertTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorOutputTableHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorPageSink;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.NodeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PageIndexerFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.fs.s3presto.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.flink.fs.s3presto.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.flink.fs.s3presto.shaded.io.airlift.concurrent.Threads;
import org.apache.flink.fs.s3presto.shaded.io.airlift.event.client.EventClient;
import org.apache.flink.fs.s3presto.shaded.io.airlift.json.JsonCodec;

public class HivePageSinkProvider
implements ConnectorPageSinkProvider {
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final HdfsEnvironment hdfsEnvironment;
    private final ExtendedHiveMetastore metastore;
    private final PageIndexerFactory pageIndexerFactory;
    private final TypeManager typeManager;
    private final int maxOpenPartitions;
    private final boolean immutablePartitions;
    private final LocationService locationService;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final HiveSessionProperties hiveSessionProperties;

    @Inject
    public HivePageSinkProvider(Set<HiveFileWriterFactory> fileWriterFactories, HdfsEnvironment hdfsEnvironment, ExtendedHiveMetastore metastore, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HiveClientConfig config, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties) {
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.pageIndexerFactory = Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.maxOpenPartitions = config.getMaxPartitionsPerWriter();
        this.immutablePartitions = config.isImmutablePartitions();
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.writeVerificationExecutor = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(config.getWriteValidationThreads(), Threads.daemonThreadsNamed((String)"hive-write-validation-%s")));
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        this.hiveSessionProperties = Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorOutputTableHandle tableHandle) {
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        return this.createPageSink(handle, true, session);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorInsertTableHandle tableHandle) {
        HiveInsertTableHandle handle = (HiveInsertTableHandle)tableHandle;
        return this.createPageSink(handle, false, session);
    }

    private ConnectorPageSink createPageSink(HiveWritableTableHandle handle, boolean isCreateTable, ConnectorSession session) {
        OptionalInt bucketCount = handle.getBucketProperty().isPresent() ? OptionalInt.of(handle.getBucketProperty().get().getBucketCount()) : OptionalInt.empty();
        HiveWriterFactory writerFactory = new HiveWriterFactory(this.fileWriterFactories, handle.getSchemaName(), handle.getTableName(), isCreateTable, handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionStorageFormat(), bucketCount, handle.getLocationHandle(), this.locationService, handle.getFilePrefix(), new HivePageSinkMetadataProvider(handle.getPageSinkMetadata(), this.metastore), this.typeManager, this.hdfsEnvironment, this.immutablePartitions, session, this.nodeManager, this.eventClient, this.hiveSessionProperties);
        return new HivePageSink(writerFactory, handle.getInputColumns(), handle.getBucketProperty(), this.pageIndexerFactory, this.typeManager, this.hdfsEnvironment, this.maxOpenPartitions, this.writeVerificationExecutor, this.partitionUpdateCodec, session);
    }
}

