/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ThriftHiveMetastoreClient;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.HiveMetastoreClient;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.thrift.Transport;
import org.apache.flink.fs.s3presto.shaded.com.google.common.net.HostAndPort;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;
import org.apache.flink.fs.s3presto.shaded.org.apache.thrift.transport.TTransportException;

public class HiveMetastoreClientFactory {
    private final HostAndPort socksProxy;
    private final int timeoutMillis;
    private final HiveMetastoreAuthentication metastoreAuthentication;

    public HiveMetastoreClientFactory(@Nullable HostAndPort socksProxy, Duration timeout, HiveMetastoreAuthentication metastoreAuthentication) {
        this.socksProxy = socksProxy;
        this.timeoutMillis = Math.toIntExact(timeout.toMillis());
        this.metastoreAuthentication = Objects.requireNonNull(metastoreAuthentication, "metastoreAuthentication is null");
    }

    @Inject
    public HiveMetastoreClientFactory(HiveClientConfig config, HiveMetastoreAuthentication metastoreAuthentication) {
        this(config.getMetastoreSocksProxy(), config.getMetastoreTimeout(), metastoreAuthentication);
    }

    public HiveMetastoreClient create(String host, int port) throws TTransportException {
        return new ThriftHiveMetastoreClient(Transport.create(host, port, this.socksProxy, this.timeoutMillis, this.metastoreAuthentication));
    }
}

