/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DecimalType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Decimals;

public final class HiveDecimalParser {
    private HiveDecimalParser() {
    }

    public static BigDecimal parseHiveDecimal(byte[] bytes, int start, int length, DecimalType columnType) {
        BigDecimal parsed = new BigDecimal(new String(bytes, start, length, StandardCharsets.UTF_8));
        if (parsed.scale() > columnType.getScale()) {
            parsed = parsed.setScale(columnType.getScale(), RoundingMode.HALF_UP);
        }
        return Decimals.rescale((BigDecimal)parsed, (DecimalType)columnType);
    }
}

