/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSourceProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.RecordCursor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.StandardErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.VarcharType;
import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;

public class HiveCoercionRecordCursor
implements RecordCursor {
    private final RecordCursor delegate;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Coercer[] coercers;

    public HiveCoercionRecordCursor(List<HivePageSourceProvider.ColumnMapping> columnMappings, TypeManager typeManager, RecordCursor delegate) {
        Objects.requireNonNull(columnMappings, "columns is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = ImmutableList.copyOf(columnMappings);
        int size = columnMappings.size();
        this.coercers = new Coercer[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            if (!columnMapping.getCoercionFrom().isPresent()) continue;
            this.coercers[columnIndex] = HiveCoercionRecordCursor.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType());
        }
    }

    public long getTotalBytes() {
        return this.delegate.getTotalBytes();
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public Type getType(int field) {
        return this.delegate.getType(field);
    }

    public boolean advanceNextPosition() {
        for (int i = 0; i < this.columnMappings.size(); ++i) {
            if (this.coercers[i] == null) continue;
            this.coercers[i].reset();
        }
        return this.delegate.advanceNextPosition();
    }

    public boolean getBoolean(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getBoolean(field);
        }
        return this.coercers[field].getBoolean(this.delegate, field);
    }

    public long getLong(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getLong(field);
        }
        return this.coercers[field].getLong(this.delegate, field);
    }

    public double getDouble(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getDouble(field);
        }
        return this.coercers[field].getDouble(this.delegate, field);
    }

    public Slice getSlice(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getSlice(field);
        }
        return this.coercers[field].getSlice(this.delegate, field);
    }

    public Object getObject(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.getObject(field);
        }
        return this.coercers[field].getObject(this.delegate, field);
    }

    public boolean isNull(int field) {
        if (this.coercers[field] == null) {
            return this.delegate.isNull(field);
        }
        return this.coercers[field].isNull(this.delegate, field);
    }

    public void close() {
        this.delegate.close();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    @VisibleForTesting
    RecordCursor getRegularColumnRecordCursor() {
        return this.delegate;
    }

    private static Coercer createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer();
        }
        if (fromType instanceof VarcharType && (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer(toHiveType);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer();
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    private static class VarcharToIntegerNumberCoercer
    extends Coercer {
        private final long maxValue;
        private final long minValue;

        public VarcharToIntegerNumberCoercer(HiveType type) {
            if (type.equals(HiveType.HIVE_BYTE)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (type.equals(HiveType.HIVE_SHORT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (type.equals(HiveType.HIVE_INT)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (type.equals(HiveType.HIVE_LONG)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from varchar to %s", type));
            }
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            try {
                long value = Long.parseLong(delegate.getSlice(field).toStringUtf8());
                if (this.minValue <= value && value <= this.maxValue) {
                    this.setLong(value);
                } else {
                    this.setIsNull(true);
                }
            }
            catch (NumberFormatException e) {
                this.setIsNull(true);
            }
        }
    }

    private static class FloatToDoubleCoercer
    extends Coercer {
        private FloatToDoubleCoercer() {
        }

        @Override
        protected void coerce(RecordCursor delegate, int field) {
            this.setDouble(Float.intBitsToFloat((int)delegate.getLong(field)));
        }
    }

    private static class IntegerNumberToVarcharCoercer
    extends Coercer {
        private IntegerNumberToVarcharCoercer() {
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            this.setSlice(Slices.utf8Slice(String.valueOf(delegate.getLong(field))));
        }
    }

    private static class IntegerNumberUpscaleCoercer
    extends Coercer {
        private IntegerNumberUpscaleCoercer() {
        }

        @Override
        public void coerce(RecordCursor delegate, int field) {
            this.setLong(delegate.getLong(field));
        }
    }

    private static abstract class Coercer {
        private boolean isNull;
        private boolean loaded;
        private boolean booleanValue;
        private long longValue;
        private double doubleValue;
        private Slice sliceValue;
        private Object objectValue;

        private Coercer() {
        }

        public void reset() {
            this.isNull = false;
            this.loaded = false;
        }

        public boolean isNull(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.isNull;
        }

        public boolean getBoolean(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.booleanValue;
        }

        public long getLong(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.longValue;
        }

        public double getDouble(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.doubleValue;
        }

        public Slice getSlice(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.sliceValue;
        }

        public Object getObject(RecordCursor delegate, int field) {
            this.assureLoaded(delegate, field);
            return this.objectValue;
        }

        private void assureLoaded(RecordCursor delegate, int field) {
            if (!this.loaded) {
                this.isNull = delegate.isNull(field);
                if (!this.isNull) {
                    this.coerce(delegate, field);
                }
                this.loaded = true;
            }
        }

        protected abstract void coerce(RecordCursor var1, int var2);

        protected void setBoolean(boolean value) {
            this.booleanValue = value;
        }

        protected void setLong(long value) {
            this.longValue = value;
        }

        protected void setDouble(double value) {
            this.doubleValue = value;
        }

        protected void setSlice(Slice value) {
            this.sliceValue = value;
        }

        protected void setObject(Object value) {
            this.objectValue = value;
        }

        protected void setIsNull(boolean isNull) {
            this.isNull = isNull;
        }
    }
}

