/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketProperty;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Table;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Page;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.Domain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.NullableValue;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.ValueSet;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Maps;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Sets;
import org.apache.flink.fs.s3presto.shaded.com.google.common.primitives.Shorts;
import org.apache.flink.fs.s3presto.shaded.com.google.common.primitives.SignedBytes;
import org.apache.flink.fs.s3presto.shaded.io.airlift.log.Logger;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.io.DefaultHivePartitioner;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

final class HiveBucketing {
    private static final Logger log = Logger.get(HiveBucketing.class);
    private static final Set<PrimitiveObjectInspector.PrimitiveCategory> SUPPORTED_TYPES = Sets.immutableEnumSet((Enum)PrimitiveObjectInspector.PrimitiveCategory.BYTE, (Enum[])new PrimitiveObjectInspector.PrimitiveCategory[]{PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.INT, PrimitiveObjectInspector.PrimitiveCategory.LONG, PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, PrimitiveObjectInspector.PrimitiveCategory.STRING});

    private HiveBucketing() {
    }

    public static int getHiveBucket(List<TypeInfo> types, Page page, int position, int bucketCount) {
        return (HiveBucketing.getBucketHashCode(types, page, position) & Integer.MAX_VALUE) % bucketCount;
    }

    private static int getBucketHashCode(List<TypeInfo> types, Page page, int position) {
        int result = 0;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            int fieldHash = HiveBucketing.hash(types.get(i), page.getBlock(i), position);
            result = result * 31 + fieldHash;
        }
        return result;
    }

    private static int hash(TypeInfo type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        switch (type.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo typeInfo = (PrimitiveTypeInfo)type;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
                Type prestoType = Objects.requireNonNull(HiveType.getPrimitiveType(typeInfo));
                switch (primitiveCategory) {
                    case BOOLEAN: {
                        return prestoType.getBoolean(block, position) ? 1 : 0;
                    }
                    case BYTE: {
                        return SignedBytes.checkedCast(prestoType.getLong(block, position));
                    }
                    case SHORT: {
                        return Shorts.checkedCast(prestoType.getLong(block, position));
                    }
                    case INT: {
                        return Math.toIntExact(prestoType.getLong(block, position));
                    }
                    case LONG: {
                        long bigintValue = prestoType.getLong(block, position);
                        return (int)(bigintValue >>> 32 ^ bigintValue);
                    }
                    case FLOAT: {
                        return (int)prestoType.getLong(block, position);
                    }
                    case DOUBLE: {
                        long doubleValue = Double.doubleToLongBits(prestoType.getDouble(block, position));
                        return (int)(doubleValue >>> 32 ^ doubleValue);
                    }
                    case STRING: {
                        return HiveBucketing.hashBytes(0, prestoType.getSlice(block, position));
                    }
                    case VARCHAR: {
                        return HiveBucketing.hashBytes(1, prestoType.getSlice(block, position));
                    }
                    case DATE: {
                        long days = prestoType.getLong(block, position);
                        return Math.toIntExact(days);
                    }
                    case TIMESTAMP: {
                        long millisSinceEpoch = prestoType.getLong(block, position);
                        long secondsAndNanos = (Math.floorDiv(millisSinceEpoch, 1000L) << 30) + Math.floorMod(millisSinceEpoch, 1000L);
                        return (int)(secondsAndNanos >>> 32 ^ secondsAndNanos);
                    }
                }
                throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive primitive category: " + primitiveCategory.toString() + ".");
            }
            case LIST: {
                TypeInfo elementTypeInfo = ((ListTypeInfo)type).getListElementTypeInfo();
                Block elementsBlock = (Block)block.getObject(position, Block.class);
                int result = 0;
                for (int i = 0; i < elementsBlock.getPositionCount(); ++i) {
                    result = result * 31 + HiveBucketing.hash(elementTypeInfo, elementsBlock, i);
                }
                return result;
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)type;
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                Block elementsBlock = (Block)block.getObject(position, Block.class);
                int result = 0;
                for (int i = 0; i < elementsBlock.getPositionCount(); i += 2) {
                    result += HiveBucketing.hash(keyTypeInfo, elementsBlock, i) ^ HiveBucketing.hash(valueTypeInfo, elementsBlock, i + 1);
                }
                return result;
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory().toString() + ".");
    }

    private static int hashBytes(int initialValue, Slice bytes) {
        int result = initialValue;
        for (int i = 0; i < bytes.length(); ++i) {
            result = result * 31 + bytes.getByte(i);
        }
        return result;
    }

    public static Optional<HiveBucketHandle> getHiveBucketHandle(String connectorId, Table table) {
        Optional<HiveBucketProperty> hiveBucketProperty = table.getStorage().getBucketProperty();
        if (!hiveBucketProperty.isPresent()) {
            return Optional.empty();
        }
        Map map = HiveUtil.getRegularColumnHandles(connectorId, table).stream().collect(Collectors.toMap(HiveColumnHandle::getName, Function.identity()));
        ImmutableList.Builder bucketColumns = ImmutableList.builder();
        for (String bucketColumnName : hiveBucketProperty.get().getBucketedBy()) {
            HiveColumnHandle bucketColumnHandle = (HiveColumnHandle)map.get(bucketColumnName);
            if (bucketColumnHandle == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s.%s' is bucketed on non-existent column '%s'", table.getDatabaseName(), table.getTableName(), bucketColumnName));
            }
            bucketColumns.add(bucketColumnHandle);
        }
        return Optional.of(new HiveBucketHandle((List<HiveColumnHandle>)((Object)bucketColumns.build()), hiveBucketProperty.get().getBucketCount()));
    }

    public static List<HiveBucket> getHiveBucketNumbers(Table table, TupleDomain<ColumnHandle> effectivePredicate) {
        if (!table.getStorage().getBucketProperty().isPresent()) {
            return ImmutableList.of();
        }
        Optional bindings = TupleDomain.extractFixedValues(effectivePredicate);
        if (!bindings.isPresent()) {
            return ImmutableList.of();
        }
        Optional<HiveBucket> singleBucket = HiveBucketing.getHiveBucket(table, (Map)bindings.get());
        if (singleBucket.isPresent()) {
            return ImmutableList.of(singleBucket.get());
        }
        if (!effectivePredicate.getDomains().isPresent()) {
            return ImmutableList.of();
        }
        Optional<Domain> domain = ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> ((HiveColumnHandle)entry.getKey()).getName().equals("$bucket")).findFirst().map(Map.Entry::getValue);
        if (!domain.isPresent()) {
            return ImmutableList.of();
        }
        ValueSet values = domain.get().getValues();
        ImmutableList.Builder builder = ImmutableList.builder();
        int bucketCount = table.getStorage().getBucketProperty().get().getBucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            if (!values.containsValue((Object)i)) continue;
            builder.add(new HiveBucket(i, bucketCount));
        }
        return builder.build();
    }

    private static Optional<HiveBucket> getHiveBucket(Table table, Map<ColumnHandle, NullableValue> bindings) {
        if (bindings.isEmpty()) {
            return Optional.empty();
        }
        List<String> bucketColumns = table.getStorage().getBucketProperty().get().getBucketedBy();
        HashMap<String, ObjectInspector> objectInspectors = new HashMap<String, ObjectInspector>();
        for (StructField structField : HiveUtil.getTableStructFields(table)) {
            objectInspectors.put(structField.getFieldName(), structField.getFieldObjectInspector());
        }
        for (String string : bucketColumns) {
            ObjectInspector objectInspector = (ObjectInspector)objectInspectors.get(string);
            if (objectInspector == null || objectInspector.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                return Optional.empty();
            }
            if (SUPPORTED_TYPES.contains(((PrimitiveObjectInspector)objectInspector).getPrimitiveCategory())) continue;
            return Optional.empty();
        }
        HashMap<String, Object> bucketBindings = new HashMap<String, Object>();
        for (Map.Entry<ColumnHandle, NullableValue> entry : bindings.entrySet()) {
            HiveColumnHandle colHandle = (HiveColumnHandle)entry.getKey();
            if (entry.getValue().isNull() || !bucketColumns.contains(colHandle.getName())) continue;
            bucketBindings.put(colHandle.getName(), entry.getValue().getValue());
        }
        if (bucketBindings.size() != bucketColumns.size()) {
            return Optional.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String column : bucketColumns) {
            builder.add(Maps.immutableEntry(objectInspectors.get(column), bucketBindings.get(column)));
        }
        return HiveBucketing.getHiveBucket((List<Map.Entry<ObjectInspector, Object>>)((Object)builder.build()), table.getStorage().getBucketProperty().get().getBucketCount());
    }

    public static Optional<HiveBucket> getHiveBucket(List<Map.Entry<ObjectInspector, Object>> columnBindings, int bucketCount) {
        try {
            GenericUDFHash udf = new GenericUDFHash();
            ObjectInspector[] objectInspectors = new ObjectInspector[columnBindings.size()];
            GenericUDF.DeferredObject[] deferredObjects = new GenericUDF.DeferredObject[columnBindings.size()];
            int i = 0;
            for (Map.Entry<ObjectInspector, Object> entry : columnBindings) {
                objectInspectors[i] = HiveBucketing.getJavaObjectInspector(entry.getKey());
                deferredObjects[i] = HiveBucketing.getJavaDeferredObject(entry.getValue(), entry.getKey());
                ++i;
            }
            ObjectInspector udfInspector = udf.initialize(objectInspectors);
            IntObjectInspector inspector = (IntObjectInspector)udfInspector;
            Object result = udf.evaluate(deferredObjects);
            HiveKey hiveKey = new HiveKey();
            hiveKey.setHashCode(inspector.get(result));
            int bucketNumber = new DefaultHivePartitioner().getBucket((Object)hiveKey, null, bucketCount);
            return Optional.of(new HiveBucket(bucketNumber, bucketCount));
        }
        catch (HiveException e) {
            log.debug(e, "Error evaluating bucket number");
            return Optional.empty();
        }
    }

    private static ObjectInspector getJavaObjectInspector(ObjectInspector objectInspector) {
        Preconditions.checkArgument(objectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE, "Unsupported object inspector category %s", (Object)objectInspector.getCategory());
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objectInspector;
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
            }
            case BYTE: {
                return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
            }
            case SHORT: {
                return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
            }
            case INT: {
                return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
            }
            case LONG: {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }
            case STRING: {
                return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
            }
        }
        throw new RuntimeException("Unsupported type: " + poi.getPrimitiveCategory());
    }

    private static GenericUDF.DeferredObject getJavaDeferredObject(Object object, ObjectInspector objectInspector) {
        Preconditions.checkArgument(objectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE, "Unsupported object inspector category %s", (Object)objectInspector.getCategory());
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)objectInspector;
        switch (poi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return new GenericUDF.DeferredJavaObject(object);
            }
            case BYTE: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).byteValue());
            }
            case SHORT: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).shortValue());
            }
            case INT: {
                return new GenericUDF.DeferredJavaObject((Object)((Long)object).intValue());
            }
            case LONG: {
                return new GenericUDF.DeferredJavaObject(object);
            }
            case STRING: {
                return new GenericUDF.DeferredJavaObject((Object)((Slice)object).toStringUtf8());
            }
        }
        throw new RuntimeException("Unsupported type: " + poi.getPrimitiveCategory());
    }

    public static class HiveBucket {
        private final int bucketNumber;
        private final int bucketCount;

        public HiveBucket(int bucketNumber, int bucketCount) {
            Preconditions.checkArgument(bucketCount > 0, "bucketCount must be greater than zero");
            Preconditions.checkArgument(bucketNumber >= 0, "bucketCount must be positive");
            Preconditions.checkArgument(bucketNumber < bucketCount, "bucketNumber must be less than bucketCount");
            this.bucketNumber = bucketNumber;
            this.bucketCount = bucketCount;
        }

        public int getBucketNumber() {
            return this.bucketNumber;
        }

        public int getBucketCount() {
            return this.bucketCount;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("bucketNumber", this.bucketNumber).add("bucketCount", this.bucketCount).toString();
        }
    }
}

