/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.codec.http.websocketx;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.buffer.ByteBuf;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.buffer.Unpooled;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.$internal.io.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public TextWebSocketFrame(String text) {
        super(TextWebSocketFrame.fromText(text));
    }

    public TextWebSocketFrame(ByteBuf binaryData) {
        super(binaryData);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, String text) {
        super(finalFragment, rsv, TextWebSocketFrame.fromText(text));
    }

    private static ByteBuf fromText(String text) {
        if (text == null || text.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(text, CharsetUtil.UTF_8);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        super(finalFragment, rsv, binaryData);
    }

    public String text() {
        return this.content().toString(CharsetUtil.UTF_8);
    }

    @Override
    public TextWebSocketFrame copy() {
        return new TextWebSocketFrame(this.isFinalFragment(), this.rsv(), this.content().copy());
    }

    @Override
    public TextWebSocketFrame duplicate() {
        return new TextWebSocketFrame(this.isFinalFragment(), this.rsv(), this.content().duplicate());
    }

    @Override
    public TextWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public TextWebSocketFrame retain(int increment) {
        super.retain(increment);
        return this;
    }
}

