/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.services.s3.model.MultiFactorAuthentication;

public class DeleteObjectsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String bucketName;
    private boolean quiet;
    private MultiFactorAuthentication mfa;
    private final List<KeyVersion> keys = new ArrayList<KeyVersion>();
    private boolean isRequesterPays;

    public DeleteObjectsRequest(String bucketName) {
        this.setBucketName(bucketName);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public DeleteObjectsRequest withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public MultiFactorAuthentication getMfa() {
        return this.mfa;
    }

    public void setMfa(MultiFactorAuthentication mfa) {
        this.mfa = mfa;
    }

    public DeleteObjectsRequest withMfa(MultiFactorAuthentication mfa) {
        this.setMfa(mfa);
        return this;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean getQuiet() {
        return this.quiet;
    }

    public DeleteObjectsRequest withQuiet(boolean quiet) {
        this.setQuiet(quiet);
        return this;
    }

    public void setKeys(List<KeyVersion> keys) {
        this.keys.clear();
        this.keys.addAll(keys);
    }

    public DeleteObjectsRequest withKeys(List<KeyVersion> keys) {
        this.setKeys(keys);
        return this;
    }

    public List<KeyVersion> getKeys() {
        return this.keys;
    }

    public DeleteObjectsRequest withKeys(String ... keys) {
        ArrayList<KeyVersion> keyVersions = new ArrayList<KeyVersion>(keys.length);
        for (String key : keys) {
            keyVersions.add(new KeyVersion(key));
        }
        this.setKeys(keyVersions);
        return this;
    }

    public boolean isRequesterPays() {
        return this.isRequesterPays;
    }

    public void setRequesterPays(boolean isRequesterPays) {
        this.isRequesterPays = isRequesterPays;
    }

    public DeleteObjectsRequest withRequesterPays(boolean isRequesterPays) {
        this.setRequesterPays(isRequesterPays);
        return this;
    }

    public static class KeyVersion
    implements Serializable {
        private final String key;
        private final String version;

        public KeyVersion(String key) {
            this(key, null);
        }

        public KeyVersion(String key, String version) {
            this.key = key;
            this.version = version;
        }

        public String getKey() {
            return this.key;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

