/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.auth;

import java.net.URI;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonWebServiceClient;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.Request;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.Signer;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.SignerFactory;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.SignerParams;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.SignerTypeAware;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.auth.SignerProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.internal.auth.SignerProviderContext;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.util.AwsHostNameUtils;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.defaultSigner = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext context) {
        Request<?> request = context.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (context.isRedirect()) {
                return this.awsClient.getSignerByURI(context.getUri());
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams params = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), params);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest originalRequest) {
        return !(originalRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uri) {
        String regionName = this.awsClient.getSignerRegionOverride();
        if (regionName == null) {
            regionName = AwsHostNameUtils.parseRegion(uri.getHost(), this.awsClient.getServiceName());
        }
        return regionName;
    }
}

