/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.client;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.SdkTestInternalApi;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.annotation.ThreadSafe;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.TimeoutThreadPoolBuilder;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.client.ClientExecutionAbortTaskImpl;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTask;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.client.ClientExecutionAbortTrackerTaskImpl;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.http.timers.client.NoOpClientExecutionAbortTrackerTask;

@SdkInternalApi
@ThreadSafe
public class ClientExecutionTimer {
    private static final String threadNamePrefix = "AwsSdkClientExecutionTimerThread";
    private volatile ScheduledThreadPoolExecutor executor;

    public ClientExecutionAbortTrackerTask startTimer(int clientExecutionTimeoutMillis) {
        if (this.isTimeoutDisabled(clientExecutionTimeoutMillis)) {
            return NoOpClientExecutionAbortTrackerTask.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        return this.scheduleTimerTask(clientExecutionTimeoutMillis);
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool(threadNamePrefix);
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    private ClientExecutionAbortTrackerTask scheduleTimerTask(int clientExecutionTimeoutMillis) {
        ClientExecutionAbortTaskImpl timerTask = new ClientExecutionAbortTaskImpl(Thread.currentThread());
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)clientExecutionTimeoutMillis, TimeUnit.MILLISECONDS);
        return new ClientExecutionAbortTrackerTaskImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int clientExecutionTimeoutMillis) {
        return clientExecutionTimeoutMillis <= 0;
    }
}

