/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth;

import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSCredentials;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.ContainerCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.com.amazonaws.auth.InstanceProfileCredentialsProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.commons.logging.Log;
import org.apache.flink.fs.s3presto.shaded.org.apache.commons.logging.LogFactory;

public class EC2ContainerCredentialsProviderWrapper
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(EC2ContainerCredentialsProviderWrapper.class);
    private final AWSCredentialsProvider provider = this.initializeProvider();

    private AWSCredentialsProvider initializeProvider() {
        try {
            return System.getenv("AWS_CONTAINER_CREDENTIALS_RELATIVE_URI") != null ? new ContainerCredentialsProvider() : InstanceProfileCredentialsProvider.getInstance();
        }
        catch (SecurityException securityException) {
            LOG.debug("Security manager did not allow access to the ECS credentials environment variable AWS_CONTAINER_CREDENTIALS_RELATIVE_URI. Please provide access to this environment variable if you want to load credentials from ECS Container.");
            return InstanceProfileCredentialsProvider.getInstance();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.provider.getCredentials();
    }

    @Override
    public void refresh() {
        this.provider.refresh();
    }
}

