/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.fs.s3presto.shaded.org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3FileSystemFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(S3FileSystemFactory.class);
    private static final String[] CONFIG_PREFIXES = new String[]{"s3.", "presto.s3."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"presto.s3.access.key", "presto.s3.access-key"}, {"presto.s3.secret.key", "presto.s3.secret-key"}};
    private org.apache.flink.configuration.Configuration flinkConfig;
    private Configuration hadoopConfig;

    public String getScheme() {
        return "s3";
    }

    public void configure(org.apache.flink.configuration.Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public FileSystem create(URI fsUri) throws IOException {
        LOG.debug("Creating S3 file system (backed by a Hadoop s3a file system");
        try {
            Configuration hadoopConfig = this.hadoopConfig;
            if (hadoopConfig == null) {
                if (this.flinkConfig != null) {
                    LOG.debug("Loading Hadoop configuration for Presto S3 file system");
                    hadoopConfig = HadoopUtils.getHadoopConfiguration(this.flinkConfig);
                    for (String key : this.flinkConfig.keySet()) {
                        for (String prefix : CONFIG_PREFIXES) {
                            if (!key.startsWith(prefix)) continue;
                            String value = this.flinkConfig.getString(key, null);
                            String newKey = "presto.s3." + key.substring(prefix.length());
                            hadoopConfig.set(newKey, this.flinkConfig.getString(key, null));
                            LOG.debug("Adding Flink config entry for {} as {}={} to Hadoop config for Presto S3 File System", new Object[]{key, newKey, value});
                        }
                    }
                    for (String[] mirrored : MIRRORED_CONFIG_KEYS) {
                        String value = hadoopConfig.get(mirrored[0], null);
                        if (value == null) continue;
                        hadoopConfig.set(mirrored[1], value);
                    }
                    this.hadoopConfig = hadoopConfig;
                } else {
                    LOG.warn("The factory has not been configured prior to loading the S3 file system. Using Hadoop configuration from the classpath.");
                    this.hadoopConfig = hadoopConfig = new Configuration();
                }
            }
            String scheme = fsUri.getScheme();
            String authority = fsUri.getAuthority();
            URI initUri = scheme == null && authority == null ? new URI("s3://s3.amazonaws.com") : (scheme != null && authority == null ? new URI(scheme + "://s3.amazonaws.com") : fsUri);
            PrestoS3FileSystem fs = new PrestoS3FileSystem();
            fs.initialize(initUri, hadoopConfig);
            return new HadoopFileSystem(fs);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

