/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.hive.util.DecimalUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slices;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyDate;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.joda.time.DateTimeZone;

public final class SerDeUtils {
    private SerDeUtils() {
    }

    public static Block getBlockObject(Type type, Object object, ObjectInspector objectInspector) {
        return Objects.requireNonNull(SerDeUtils.serializeObject(type, null, object, objectInspector), "serialized result is null");
    }

    public static Block serializeObject(Type type, BlockBuilder builder, Object object, ObjectInspector inspector) {
        return SerDeUtils.serializeObject(type, builder, object, inspector, true);
    }

    @VisibleForTesting
    public static Block serializeObject(Type type, BlockBuilder builder, Object object, ObjectInspector inspector, boolean filterNullMapKeys) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                SerDeUtils.serializePrimitive(type, builder, object, (PrimitiveObjectInspector)inspector);
                return null;
            }
            case LIST: {
                return SerDeUtils.serializeList(type, builder, object, (ListObjectInspector)inspector);
            }
            case MAP: {
                return SerDeUtils.serializeMap(type, builder, object, (MapObjectInspector)inspector, filterNullMapKeys);
            }
            case STRUCT: {
                return SerDeUtils.serializeStruct(type, builder, object, (StructObjectInspector)inspector);
            }
        }
        throw new RuntimeException("Unknown object inspector category: " + inspector.getCategory());
    }

    private static void serializePrimitive(Type type, BlockBuilder builder, Object object, PrimitiveObjectInspector inspector) {
        Objects.requireNonNull(builder, "parent builder is null");
        if (object == null) {
            builder.appendNull();
            return;
        }
        switch (inspector.getPrimitiveCategory()) {
            case BOOLEAN: {
                BooleanType.BOOLEAN.writeBoolean(builder, ((BooleanObjectInspector)inspector).get(object));
                return;
            }
            case BYTE: {
                TinyintType.TINYINT.writeLong(builder, ((ByteObjectInspector)inspector).get(object));
                return;
            }
            case SHORT: {
                SmallintType.SMALLINT.writeLong(builder, ((ShortObjectInspector)inspector).get(object));
                return;
            }
            case INT: {
                IntegerType.INTEGER.writeLong(builder, ((IntObjectInspector)inspector).get(object));
                return;
            }
            case LONG: {
                BigintType.BIGINT.writeLong(builder, ((LongObjectInspector)inspector).get(object));
                return;
            }
            case FLOAT: {
                RealType.REAL.writeLong(builder, Float.floatToRawIntBits(((FloatObjectInspector)inspector).get(object)));
                return;
            }
            case DOUBLE: {
                DoubleType.DOUBLE.writeDouble(builder, ((DoubleObjectInspector)inspector).get(object));
                return;
            }
            case STRING: {
                type.writeSlice(builder, Slices.utf8Slice(((StringObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
            case VARCHAR: {
                type.writeSlice(builder, Slices.utf8Slice(((HiveVarcharObjectInspector)inspector).getPrimitiveJavaObject(object).getValue()));
                return;
            }
            case CHAR: {
                CharType charType = (CharType)type;
                HiveChar hiveChar = ((HiveCharObjectInspector)inspector).getPrimitiveJavaObject(object);
                type.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces(Slices.utf8Slice(hiveChar.getValue()), charType.getLength()));
                return;
            }
            case DATE: {
                DateType.DATE.writeLong(builder, SerDeUtils.formatDateAsLong(object, (DateObjectInspector)inspector));
                return;
            }
            case TIMESTAMP: {
                TimestampType.TIMESTAMP.writeLong(builder, SerDeUtils.formatTimestampAsLong(object, (TimestampObjectInspector)inspector));
                return;
            }
            case BINARY: {
                VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer(((BinaryObjectInspector)inspector).getPrimitiveJavaObject(object)));
                return;
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)type;
                HiveDecimalWritable hiveDecimal = ((HiveDecimalObjectInspector)inspector).getPrimitiveWritableObject(object);
                if (decimalType.isShort()) {
                    decimalType.writeLong(builder, DecimalUtils.getShortDecimalValue(hiveDecimal, decimalType.getScale()));
                } else {
                    decimalType.writeSlice(builder, DecimalUtils.getLongDecimalValue(hiveDecimal, decimalType.getScale()));
                }
                return;
            }
        }
        throw new RuntimeException("Unknown primitive type: " + inspector.getPrimitiveCategory());
    }

    private static Block serializeList(Type type, BlockBuilder builder, Object object, ListObjectInspector inspector) {
        List list = inspector.getList(object);
        if (list == null) {
            Objects.requireNonNull(builder, "parent builder is null").appendNull();
            return null;
        }
        List<Type> typeParameters = type.getTypeParameters();
        Preconditions.checkArgument(typeParameters.size() == 1, "list must have exactly 1 type parameter");
        Type elementType = typeParameters.get(0);
        ObjectInspector elementInspector = inspector.getListElementObjectInspector();
        BlockBuilder currentBuilder = builder != null ? builder.beginBlockEntry() : elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            SerDeUtils.serializeObject(elementType, currentBuilder, element, elementInspector);
        }
        if (builder != null) {
            builder.closeEntry();
            return null;
        }
        Block resultBlock = currentBuilder.build();
        return resultBlock;
    }

    private static Block serializeMap(Type type, BlockBuilder builder, Object object, MapObjectInspector inspector, boolean filterNullMapKeys) {
        Map map = inspector.getMap(object);
        if (map == null) {
            Objects.requireNonNull(builder, "parent builder is null").appendNull();
            return null;
        }
        List<Type> typeParameters = type.getTypeParameters();
        Preconditions.checkArgument(typeParameters.size() == 2, "map must have exactly 2 type parameter");
        Type keyType = typeParameters.get(0);
        Type valueType = typeParameters.get(1);
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            if (filterNullMapKeys && entry.getKey() == null) continue;
            SerDeUtils.serializeObject(keyType, currentBuilder, entry.getKey(), keyInspector);
            SerDeUtils.serializeObject(valueType, currentBuilder, entry.getValue(), valueInspector);
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject(builder, 0);
        }
        return null;
    }

    private static Block serializeStruct(Type type, BlockBuilder builder, Object object, StructObjectInspector inspector) {
        if (object == null) {
            Objects.requireNonNull(builder, "parent builder is null").appendNull();
            return null;
        }
        List<Type> typeParameters = type.getTypeParameters();
        List allStructFieldRefs = inspector.getAllStructFieldRefs();
        Preconditions.checkArgument(typeParameters.size() == allStructFieldRefs.size());
        boolean builderSynthesized = false;
        if (builder == null) {
            builderSynthesized = true;
            builder = type.createBlockBuilder(null, 1);
        }
        BlockBuilder currentBuilder = builder.beginBlockEntry();
        for (int i = 0; i < typeParameters.size(); ++i) {
            StructField field = (StructField)allStructFieldRefs.get(i);
            SerDeUtils.serializeObject(typeParameters.get(i), currentBuilder, inspector.getStructFieldData(object, field), field.getFieldObjectInspector());
        }
        builder.closeEntry();
        if (builderSynthesized) {
            return (Block)type.getObject(builder, 0);
        }
        return null;
    }

    private static long formatDateAsLong(Object object, DateObjectInspector inspector) {
        if (object instanceof LazyDate) {
            return ((DateWritable)((LazyDate)object).getWritableObject()).getDays();
        }
        if (object instanceof DateWritable) {
            return ((DateWritable)object).getDays();
        }
        long millisLocal = inspector.getPrimitiveJavaObject(object).getTime();
        long millisUtc = DateTimeZone.getDefault().getMillisKeepLocal(DateTimeZone.UTC, millisLocal);
        return TimeUnit.MILLISECONDS.toDays(millisUtc);
    }

    private static long formatTimestampAsLong(Object object, TimestampObjectInspector inspector) {
        Timestamp timestamp = SerDeUtils.getTimestamp(object, inspector);
        return timestamp.getTime();
    }

    private static Timestamp getTimestamp(Object object, TimestampObjectInspector inspector) {
        if (object instanceof TimestampWritable) {
            return ((TimestampWritable)object).getTimestamp();
        }
        return inspector.getPrimitiveJavaObject(object);
    }
}

