/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.util.CustomSplitConverter;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.hadoop.realtime.HoodieRealtimeFileSplit;

public class HudiRealtimeSplitConverter
implements CustomSplitConverter {
    public static final String CUSTOM_SPLIT_CLASS_KEY = "custom_split_class";
    private static final String HUDI_DELTA_FILEPATHS_KEY = "hudi_delta_filepaths";
    private static final String HUDI_BASEPATH_KEY = "hudi_basepath";
    private static final String HUDI_MAX_COMMIT_TIME_KEY = "hudi_max_commit_time";

    @Override
    public Optional<Map<String, String>> extractCustomSplitInfo(FileSplit split) {
        if (split instanceof HoodieRealtimeFileSplit) {
            HoodieRealtimeFileSplit hudiSplit = (HoodieRealtimeFileSplit)split;
            ImmutableMap<String, String> customSplitInfo = ImmutableMap.builder().put(CUSTOM_SPLIT_CLASS_KEY, HoodieRealtimeFileSplit.class.getName()).put(HUDI_DELTA_FILEPATHS_KEY, String.join((CharSequence)",", hudiSplit.getDeltaLogPaths())).put(HUDI_BASEPATH_KEY, hudiSplit.getBasePath()).put(HUDI_MAX_COMMIT_TIME_KEY, hudiSplit.getMaxCommitTime()).build();
            return Optional.of(customSplitInfo);
        }
        return Optional.empty();
    }

    @Override
    public Optional<FileSplit> recreateFileSplitWithCustomInfo(FileSplit split, Map<String, String> customSplitInfo) throws IOException {
        String customSplitClass = customSplitInfo.get(CUSTOM_SPLIT_CLASS_KEY);
        if (HoodieRealtimeFileSplit.class.getName().equals(customSplitClass)) {
            Objects.requireNonNull(customSplitInfo.get(HUDI_DELTA_FILEPATHS_KEY), "HUDI_DELTA_FILEPATHS_KEY is missing");
            List<String> deltaLogPaths = Arrays.asList(customSplitInfo.get(HUDI_DELTA_FILEPATHS_KEY).split(","));
            return Optional.of(new HoodieRealtimeFileSplit(split, Objects.requireNonNull(customSplitInfo.get(HUDI_BASEPATH_KEY), "HUDI_BASEPATH_KEY is missing"), deltaLogPaths, Objects.requireNonNull(customSplitInfo.get(HUDI_MAX_COMMIT_TIME_KEY), "HUDI_MAX_COMMIT_TIME_KEY is missing")));
        }
        return Optional.empty();
    }
}

