/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.util.CustomSplitConverter;
import com.facebook.presto.hive.util.HudiRealtimeSplitConverter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.mapred.FileSplit;

public class CustomSplitConversionUtils {
    private static final List<CustomSplitConverter> converters = ImmutableList.of(new HudiRealtimeSplitConverter());

    private CustomSplitConversionUtils() {
    }

    public static Map<String, String> extractCustomSplitInfo(FileSplit split) {
        for (CustomSplitConverter converter : converters) {
            Optional<Map<String, String>> customSplitData = converter.extractCustomSplitInfo(split);
            if (!customSplitData.isPresent()) continue;
            return customSplitData.get();
        }
        return ImmutableMap.of();
    }

    public static FileSplit recreateSplitWithCustomInfo(FileSplit split, Map<String, String> customSplitInfo) {
        for (CustomSplitConverter converter : converters) {
            Optional<FileSplit> fileSplit;
            try {
                fileSplit = converter.recreateFileSplitWithCustomInfo(split, customSplitInfo);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Split converter %s failed to create FileSplit.", converter.getClass()), (Throwable)e);
            }
            if (!fileSplit.isPresent()) continue;
            return fileSplit.get();
        }
        return split;
    }
}

