/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.parquet.ParquetTimestampUtils;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class AggregatedParquetPageSource
implements ConnectorPageSource {
    private final List<HiveColumnHandle> columnHandles;
    private final ParquetMetadata parquetMetadata;
    private final TypeManager typeManager;
    private final StandardFunctionResolution functionResolution;
    private static final int batchSize = 1;
    private boolean completed;
    private long readTimeNanos;
    private long completedBytes;

    public AggregatedParquetPageSource(List<HiveColumnHandle> columnHandles, ParquetMetadata parquetMetadata, TypeManager typeManager, StandardFunctionResolution functionResolution) {
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        this.parquetMetadata = Objects.requireNonNull(parquetMetadata, "fileMetadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getCompletedPositions() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.completed;
    }

    public Page getNextPage() {
        if (this.completed) {
            return null;
        }
        long start = System.nanoTime();
        Block[] blocks = new Block[this.columnHandles.size()];
        for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
            HiveColumnHandle columnHandle = this.columnHandles.get(fieldId);
            AggregationNode.Aggregation aggregation = columnHandle.getPartialAggregation().get();
            com.facebook.presto.common.type.Type type = this.typeManager.getType(columnHandle.getTypeSignature());
            BlockBuilder blockBuilder = type.createBlockBuilder(null, 1, 0);
            int columnIndex = columnHandle.getHiveColumnIndex();
            FunctionHandle functionHandle = aggregation.getFunctionHandle();
            if (this.functionResolution.isCountFunction(functionHandle)) {
                long rowCount = this.getRowCountFromParquetMetadata(this.parquetMetadata);
                if (!aggregation.getArguments().isEmpty()) {
                    rowCount -= this.getNumNulls(this.parquetMetadata, columnIndex);
                }
                blockBuilder = blockBuilder.writeLong(rowCount);
            } else if (this.functionResolution.isMaxFunction(functionHandle)) {
                this.writeMinMax(this.parquetMetadata, columnIndex, blockBuilder, type, columnHandle.getHiveType(), false);
            } else if (this.functionResolution.isMinFunction(functionHandle)) {
                this.writeMinMax(this.parquetMetadata, columnIndex, blockBuilder, type, columnHandle.getHiveType(), true);
            } else {
                throw new UnsupportedOperationException(aggregation.getFunctionHandle().toString() + " is not supported");
            }
            blocks[fieldId] = blockBuilder.build();
        }
        this.completed = true;
        this.readTimeNanos += System.nanoTime() - start;
        return new Page(1, blocks);
    }

    private long getRowCountFromParquetMetadata(ParquetMetadata parquetMetadata) {
        long rowCount = 0L;
        for (BlockMetaData blockMetaData : parquetMetadata.getBlocks()) {
            rowCount += blockMetaData.getRowCount();
        }
        this.completedBytes += (long)IntegerType.INTEGER.getFixedSize();
        return rowCount;
    }

    private long getNumNulls(ParquetMetadata parquetMetadata, int columnIndex) {
        long numNulls = 0L;
        for (BlockMetaData blockMetaData : parquetMetadata.getBlocks()) {
            Statistics statistics = ((ColumnChunkMetaData)blockMetaData.getColumns().get(columnIndex)).getStatistics();
            if (!statistics.isNumNullsSet()) {
                throw new UnsupportedOperationException("Number of nulls not set for parquet file. Set session property hive.pushdown_partial_aggregations_into_scan=false and execute query again");
            }
            numNulls += statistics.getNumNulls();
        }
        this.completedBytes += (long)IntegerType.INTEGER.getFixedSize();
        return numNulls;
    }

    private void writeMinMax(ParquetMetadata parquetMetadata, int columnIndex, BlockBuilder blockBuilder, com.facebook.presto.common.type.Type type, HiveType hiveType, boolean isMin) {
        Type parquetType = parquetMetadata.getFileMetaData().getSchema().getType(columnIndex);
        if (parquetType instanceof GroupType) {
            throw new IllegalArgumentException("Unsupported type : " + parquetType.toString());
        }
        Comparable value = null;
        for (BlockMetaData blockMetaData : parquetMetadata.getBlocks()) {
            Comparable currentValue;
            Statistics statistics = ((ColumnChunkMetaData)blockMetaData.getColumns().get(columnIndex)).getStatistics();
            if (!statistics.hasNonNullValue()) {
                throw new UnsupportedOperationException("No min/max found for parquet file. Set session property hive.pushdown_partial_aggregations_into_scan=false and execute query again");
            }
            if (isMin) {
                currentValue = statistics.genericGetMin();
                if (currentValue == null || value != null && currentValue.compareTo(value) >= 0) continue;
                value = currentValue;
                continue;
            }
            currentValue = statistics.genericGetMax();
            if (currentValue == null || value != null && currentValue.compareTo(value) <= 0) continue;
            value = currentValue;
        }
        if (type instanceof FixedWidthType) {
            this.completedBytes += (long)((FixedWidthType)type).getFixedSize();
        }
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        PrimitiveType.PrimitiveTypeName parquetTypeName = parquetType.asPrimitiveType().getPrimitiveTypeName();
        switch (parquetTypeName) {
            case INT32: {
                blockBuilder.writeLong(((Integer)value).intValue());
                break;
            }
            case INT64: {
                blockBuilder.writeLong((Long)value);
                break;
            }
            case INT96: {
                blockBuilder.writeLong(ParquetTimestampUtils.getTimestampMillis((byte[])((Binary)value).getBytes(), (int)0));
                break;
            }
            case FLOAT: {
                blockBuilder.writeLong(Float.floatToRawIntBits(((Float)value).floatValue()));
                break;
            }
            case DOUBLE: {
                type.writeDouble(blockBuilder, (Double)value);
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                byte[] valBytes = ((Binary)value).getBytes();
                DecimalType decimalType = (DecimalType)hiveType.getType(this.typeManager);
                if (decimalType.isShort()) {
                    blockBuilder.writeLong(ParquetTypeUtils.getShortDecimalValue((byte[])valBytes));
                    break;
                }
                BigInteger bigIntValue = new BigInteger(valBytes);
                type.writeSlice(blockBuilder, Decimals.encodeUnscaledValue(bigIntValue));
                break;
            }
            case BINARY: {
                Slice slice = Slices.wrappedBuffer(((Binary)value).getBytes());
                blockBuilder.writeBytes(slice, 0, slice.length()).closeEntry();
                this.completedBytes += (long)slice.length();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected parquet type name: " + parquetTypeName);
            }
        }
    }

    public long getSystemMemoryUsage() {
        return 0L;
    }

    public void close() throws IOException {
    }
}

