/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.common.io.DataSink;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.facebook.presto.hive.pagefile.PageFileFooterOutput;
import com.facebook.presto.spi.page.PageDataOutput;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.jol.info.ClassLayout;

public class PageWriter
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(PageWriter.class).instanceSize();
    private final DataSink dataSink;
    private final HiveCompressionCodec compressionCodec;
    private final AtomicBoolean closed = new AtomicBoolean();
    private long bufferedBytes;
    private long retainedBytes;
    private long maxBufferedBytes;
    private List<DataOutput> bufferedPages = new ArrayList<DataOutput>();
    private List<Long> stripeOffsets = new ArrayList<Long>();
    private long stripeOffset;

    public PageWriter(DataSink dataSink, HiveCompressionCodec compressionCodec, DataSize pageFileStripeMaxSize) {
        this.dataSink = Objects.requireNonNull(dataSink, "pageDataSink is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.maxBufferedBytes = Objects.requireNonNull(pageFileStripeMaxSize, "pageFileStripeMaxSize is null").toBytes();
    }

    public long getWrittenBytes() {
        return this.dataSink.size();
    }

    public void write(SerializedPage page) throws IOException {
        PageDataOutput pageDataOutput = new PageDataOutput(page);
        long writtenSize = pageDataOutput.size();
        if (this.maxBufferedBytes - this.bufferedBytes < writtenSize) {
            this.flushStripe();
        }
        this.bufferedPages.add((DataOutput)pageDataOutput);
        this.bufferedBytes += writtenSize;
        this.retainedBytes += page.getRetainedSizeInBytes();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (!this.bufferedPages.isEmpty()) {
            this.flushStripe();
        }
        this.dataSink.write(ImmutableList.of(new PageFileFooterOutput(this.stripeOffsets, this.compressionCodec)));
        this.dataSink.close();
    }

    public void closeWithoutWrite() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.dataSink.close();
        }
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.retainedBytes + this.dataSink.getRetainedSizeInBytes();
    }

    private void flushStripe() throws IOException {
        this.dataSink.write(this.bufferedPages);
        this.stripeOffsets.add(this.stripeOffset);
        this.stripeOffset += this.bufferedBytes;
        this.bufferedPages.clear();
        this.bufferedBytes = 0L;
        this.retainedBytes = 0L;
    }
}

