/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.pagefile;

import com.facebook.presto.common.Page;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public class PageFilePageReader
implements Iterator<Page> {
    private final PagesSerde pagesSerde;
    private final SliceInput input;
    private final long readLength;

    public PageFilePageReader(long readStart, long readLength, FSDataInputStream inputStream, PagesSerde pagesSerde) throws IOException {
        this.pagesSerde = Objects.requireNonNull(pagesSerde, "pagesSerde is null");
        this.readLength = readLength;
        Objects.requireNonNull(inputStream, "inputStream is null");
        inputStream.seek(readStart);
        this.input = new InputStreamSliceInput(inputStream);
    }

    @Override
    public boolean hasNext() {
        return this.input.position() < this.readLength && this.input.isReadable();
    }

    @Override
    public Page next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SerializedPage serializedPage = PagesSerdeUtil.readSerializedPage((SliceInput)this.input);
        return this.pagesSerde.deserialize(serializedPage);
    }
}

